/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.Index;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Map;

public class MakeAliases
extends Processor {
    public MakeAliases(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        ArrayList<String> usedAliases = new ArrayList<String>();
        for (SDField field : this.schema.allConcreteFields()) {
            for (Map.Entry<String, String> e : field.getAliasToName().entrySet()) {
                String alias = e.getKey();
                String name = e.getValue();
                String errMsg = "For " + this.schema + ": alias '" + alias + "' ";
                if (validate && this.schema.existsIndex(alias)) {
                    throw new IllegalArgumentException(errMsg + "is illegal since it is the name of an index.");
                }
                if (validate && this.schema.getAttribute(alias) != null) {
                    throw new IllegalArgumentException(errMsg + "is illegal since it is the name of an attribute.");
                }
                if (validate && usedAliases.contains(alias)) {
                    throw new IllegalArgumentException(errMsg + "specified more than once.");
                }
                usedAliases.add(alias);
                Index index = field.getIndex(name);
                Attribute attribute = field.getAttributes().get(name);
                if (index != null) {
                    index.addAlias(alias);
                    continue;
                }
                if (attribute != null && !field.doesIndexing()) {
                    attribute.getAliases().add(alias);
                    continue;
                }
                index = new Index(name);
                index.addAlias(alias);
                field.addIndex(index);
            }
        }
    }
}

