/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.schema.OnnxModel;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FileDistributedOnnxModels {
    private static final Logger log = Logger.getLogger(FileDistributedOnnxModels.class.getName());
    private final Map<String, OnnxModel> models;

    public FileDistributedOnnxModels(FileRegistry fileRegistry, Collection<OnnxModel> models) {
        LinkedHashMap<String, OnnxModel> distributableModels = new LinkedHashMap<String, OnnxModel>();
        for (OnnxModel model : models) {
            model.validate();
            model.register(fileRegistry);
            distributableModels.put(model.getName(), model);
        }
        this.models = Collections.unmodifiableMap(distributableModels);
    }

    public Map<String, OnnxModel> asMap() {
        return this.models;
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        for (OnnxModel model : this.models.values()) {
            if ("".equals(model.getFileReference())) {
                log.warning("Illegal file reference " + model);
                continue;
            }
            OnnxModelsConfig.Model.Builder modelBuilder = new OnnxModelsConfig.Model.Builder();
            modelBuilder.dry_run_on_setup(true);
            modelBuilder.name(model.getName());
            modelBuilder.fileref(model.getFileReference());
            model.getInputMap().forEach((name, source) -> modelBuilder.input(new OnnxModelsConfig.Model.Input.Builder().name(name).source(source)));
            model.getOutputMap().forEach((name, as) -> modelBuilder.output(new OnnxModelsConfig.Model.Output.Builder().name(name).as(as)));
            if (model.getStatelessExecutionMode().isPresent()) {
                modelBuilder.stateless_execution_mode(model.getStatelessExecutionMode().get());
            }
            if (model.getStatelessInterOpThreads().isPresent()) {
                modelBuilder.stateless_interop_threads(model.getStatelessInterOpThreads().get().intValue());
            }
            if (model.getStatelessIntraOpThreads().isPresent()) {
                modelBuilder.stateless_intraop_threads(model.getStatelessIntraOpThreads().get().intValue());
            }
            builder.model(modelBuilder);
        }
    }
}

