/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.document.Field;
import com.yahoo.io.IOUtils;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Exportable;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.text.StringUtilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;

public abstract class Derived
implements Exportable {
    private String name;

    public Derived() {
        this("");
    }

    public Derived(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    protected void derive(Schema schema) {
        this.setName(schema.getName());
        this.derive(schema.getDocument(), schema);
        for (Index index : schema.getExplicitIndices()) {
            this.derive(index, schema);
        }
        for (SDField field : schema.allExtraFields()) {
            this.derive(field, schema);
        }
        schema.allImportedFields().forEach(importedField -> this.derive((ImmutableSDField)importedField, schema));
    }

    protected void derive(SDDocumentType document, Schema schema) {
        for (Field field : document.fieldSet()) {
            SDField sdField = (SDField)field;
            if (sdField.isExtraField()) continue;
            this.derive(sdField, schema);
        }
    }

    protected void derive(ImmutableSDField field, Schema schema) {
    }

    protected void derive(Index index, Schema schema) {
    }

    protected abstract String getDerivedName();

    protected String getIndex(int number, boolean labels) {
        return labels ? this.getName() : String.valueOf(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void export(String toDirectory) throws IOException {
        BufferedWriter writer = null;
        try {
            String fileName = this.getDerivedName() + ".cfg";
            if (toDirectory != null) {
                writer = IOUtils.createWriter((String)(toDirectory + "/" + fileName), (boolean)false);
            }
            try {
                this.exportBuilderConfig(writer);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new RuntimeException(e);
            }
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            IOUtils.closeWriter(writer);
            throw throwable;
        }
        IOUtils.closeWriter((Writer)writer);
    }

    private void exportBuilderConfig(Writer writer) throws ReflectiveOperationException, SecurityException, IllegalArgumentException, IOException {
        for (Class<?> intf : this.getClass().getInterfaces()) {
            if (!ConfigInstance.Producer.class.isAssignableFrom(intf)) continue;
            Class<?> configClass = intf.getEnclosingClass();
            String builderClassName = configClass.getCanonicalName() + "$Builder";
            Class<?> builderClass = Class.forName(builderClassName);
            ConfigInstance.Builder builder = (ConfigInstance.Builder)builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method getConfig = this.getClass().getMethod("getConfig", builderClass);
            getConfig.invoke((Object)this, builder);
            ConfigInstance inst = (ConfigInstance)configClass.getConstructor(builderClass).newInstance(builder);
            List payloadL = ConfigInstance.serialize((InnerNode)inst);
            String payload = StringUtilities.implodeMultiline((List)payloadL);
            writer.write(payload);
        }
    }

    @Override
    public String getFileName() {
        return this.getDerivedName() + ".cfg";
    }
}

