/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.api.annotations.Beta;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.config.subscription.ConfigInstanceUtil;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.ConfigTransformer;
import com.yahoo.vespa.config.GenericConfig;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.utils.FreezableMap;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractConfigProducer<CHILD extends AbstractConfigProducer<?>>
implements ConfigProducer,
ConfigInstance.Producer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger log = Logger.getLogger(AbstractConfigProducer.class.getPackage().toString());
    private final String subId;
    private String configId = null;
    private final List<Service> descendantServices = new ArrayList<Service>();
    private AbstractConfigProducer parent = null;
    private UserConfigRepo userConfigs = new UserConfigRepo();
    private final FreezableMap<String, CHILD> childrenBySubId = new FreezableMap(LinkedHashMap.class);

    protected static boolean stateIsHosted(DeployState deployState) {
        return deployState != null && deployState.isHosted();
    }

    public AbstractConfigProducer(AbstractConfigProducer parent, String subId) {
        this(subId);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    protected void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    protected final void setParent(AbstractConfigProducer<?> parent) {
        this.parent = parent;
        this.computeConfigId();
    }

    public final String getSubId() {
        return this.subId;
    }

    public AbstractConfigProducer(String subId) {
        if (subId.indexOf(47) != -1) {
            throw new IllegalArgumentException("A subId might not contain '/' : '" + subId + "'");
        }
        this.subId = subId;
    }

    protected void addChild(CHILD child) {
        if (child == null) {
            throw new IllegalArgumentException("Trying to add null child for: " + this);
        }
        if (child instanceof AbstractConfigProducerRoot) {
            throw new IllegalArgumentException("Child cannot be a root node: " + child);
        }
        ((AbstractConfigProducer)child).setParent(this);
        if (this.childrenBySubId.get(((AbstractConfigProducer)child).getSubId()) != null) {
            throw new IllegalArgumentException("Multiple services/instances of the id '" + ((AbstractConfigProducer)child).getSubId() + "' under the service/instance " + this.errorMsgClassName() + " '" + this.subId + "'. (This is commonly caused by service/node index collisions in the config.).\nExisting instance: " + this.childrenBySubId.get(((AbstractConfigProducer)child).getSubId()) + "\nAttempted to add:  " + child);
        }
        this.childrenBySubId.put(((AbstractConfigProducer)child).getSubId(), child);
        if (child instanceof Service) {
            this.addDescendantService((Service)child);
        }
    }

    public void removeChild(CHILD child) {
        if (((AbstractConfigProducer)child).getParent() != this) {
            throw new IllegalArgumentException("Could not remove " + child + ": Expected its parent to be " + this + ", but was " + ((AbstractConfigProducer)child).getParent());
        }
        if (child instanceof Service) {
            this.descendantServices.remove(child);
        }
        this.childrenBySubId.remove(((AbstractConfigProducer)child).getSubId());
        ((AbstractConfigProducer)child).setParent(null);
    }

    private String errorMsgClassName() {
        if (this.getClass().equals(SimpleConfigProducer.class)) {
            return this.parent.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName();
    }

    public void setUserConfigs(UserConfigRepo repo) {
        this.userConfigs = repo;
    }

    @Override
    public UserConfigRepo getUserConfigs() {
        return this.userConfigs;
    }

    @Override
    public final String getConfigId() {
        if (this.configId == null) {
            throw new IllegalStateException("The system topology must be frozen first.");
        }
        return this.configId;
    }

    protected void addConfigId(String id) {
        if (id == null) {
            throw new NullPointerException("Config ID cannot be null.");
        }
        this.getRoot().addDescendant(id, this);
        if (!this.isVespa() && this.getVespa() != null) {
            this.getVespa().addDescendant(this);
        }
    }

    public Map<String, CHILD> getChildren() {
        return Collections.unmodifiableMap(this.childrenBySubId);
    }

    @Beta
    public <J extends AbstractConfigProducer<?>> List<J> getChildrenByTypeRecursive(Class<J> type) {
        ArrayList<AbstractConfigProducer<Object>> validChildren = new ArrayList<AbstractConfigProducer<Object>>();
        if (this.getClass().equals(type)) {
            validChildren.add((AbstractConfigProducer)type.cast(this));
        }
        Map<String, CHILD> children = this.getChildren();
        for (AbstractConfigProducer child : children.values()) {
            validChildren.addAll(child.getChildrenByTypeRecursive(type));
        }
        return Collections.unmodifiableList(validChildren);
    }

    @Override
    public List<Service> getDescendantServices() {
        return Collections.unmodifiableList(this.descendantServices);
    }

    protected void addDescendantService(Service s) {
        this.descendantServices.add(s);
    }

    @Override
    public final boolean cascadeConfig(ConfigInstance.Builder builder) {
        boolean found = false;
        if (this.parent != null) {
            found = this.parent.cascadeConfig(builder);
        }
        boolean foundHere = builder.dispatchGetConfig((ConfigInstance.Producer)this);
        log.log(Level.FINE, () -> "cascadeconfig in " + this + ", getting config " + builder.getClass().getDeclaringClass().getName() + " for config id '" + this.configId + "' found here=" + foundHere);
        found = found || foundHere;
        return found;
    }

    @Override
    public final boolean addUserConfig(ConfigInstance.Builder builder) {
        boolean didApply = false;
        if (this.parent != null) {
            didApply = this.parent.addUserConfig(builder);
        }
        log.log(Level.FINEST, () -> "User configs is: " + this.userConfigs.toString());
        ConfigDefinitionKey key = new ConfigDefinitionKey(builder.getDefName(), builder.getDefNamespace());
        if (this.userConfigs.get(key) != null) {
            log.log(Level.FINEST, () -> "Apply in " + this.configId);
            this.applyUserConfig(builder, this.userConfigs.get(key));
            didApply = true;
        }
        return didApply;
    }

    private void applyUserConfig(ConfigInstance.Builder builder, ConfigPayloadBuilder payloadBuilder) {
        ConfigInstance.Builder override = builder instanceof GenericConfig.GenericConfigBuilder ? this.getGenericConfigBuilderOverride((GenericConfig.GenericConfigBuilder)builder, payloadBuilder) : this.getConfigInstanceBuilderOverride(builder, ConfigPayload.fromBuilder((ConfigPayloadBuilder)payloadBuilder));
        ConfigInstanceUtil.setValues((ConfigBuilder)builder, (ConfigBuilder)override);
    }

    private ConfigInstance.Builder getGenericConfigBuilderOverride(GenericConfig.GenericConfigBuilder builder, ConfigPayloadBuilder payloadBuilder) {
        ConfigDefinitionKey key = new ConfigDefinitionKey(builder.getDefName(), builder.getDefNamespace());
        return new GenericConfig.GenericConfigBuilder(key, payloadBuilder);
    }

    private ConfigInstance.Builder getConfigInstanceBuilderOverride(ConfigInstance.Builder builder, ConfigPayload payload) {
        try {
            ConfigTransformer transformer = new ConfigTransformer(builder.getClass().getEnclosingClass());
            return transformer.toConfigBuilder(payload);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error applying override to builder", e);
        }
    }

    @Override
    public HostSystem hostSystem() {
        return this.getRoot().hostSystem();
    }

    public AbstractConfigProducerRoot getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    private ApplicationConfigProducerRoot getVespa() {
        if (this.isRoot()) {
            return null;
        }
        return this.isVespa() ? (ApplicationConfigProducerRoot)this : this.parent.getVespa();
    }

    private boolean isRoot() {
        return this.parent == null;
    }

    private boolean isVespa() {
        return this instanceof ApplicationConfigProducerRoot && this.parent.isRoot();
    }

    public AbstractConfigProducer getParent() {
        return this.parent;
    }

    @Override
    public void dump(PrintStream out) {
        for (ConfigProducer c : this.getChildren().values()) {
            out.println("id: " + c.getConfigId());
            if (c.getChildren().size() <= 0) continue;
            c.dump(out);
        }
    }

    void setupConfigId(String parentConfigId) {
        if (this instanceof AbstractConfigProducerRoot) {
            this.configId = "";
        } else {
            this.configId = parentConfigId + this.subId;
            this.addConfigId(this.configId);
        }
        this.computeConfigId();
        this.setupChildConfigIds(this.getConfigIdPrefix());
    }

    private String getConfigIdPrefix() {
        if (this instanceof AbstractConfigProducerRoot || this instanceof ApplicationConfigProducerRoot) {
            return "";
        }
        if (this.configId == null) {
            return null;
        }
        return this.configId + "/";
    }

    private void computeConfigId() {
        if (this.parent == null) {
            return;
        }
        String parentConfigId = this.parent.getConfigIdPrefix();
        if (parentConfigId == null) {
            return;
        }
        String oldConfigId = this.configId;
        this.configId = this instanceof AbstractConfigProducerRoot ? "" : parentConfigId + this.subId;
        if (oldConfigId == null) {
            return;
        }
        if (!this.configId.equals(oldConfigId)) {
            throw new IllegalArgumentException("configId cannot change " + oldConfigId + " -> " + this.configId + " (invalid topology change)");
        }
    }

    private static ClassLoader findInheritedClassLoader(Class clazz, String producerName) {
        Class<?>[] interfazes;
        for (Class<?> interfaze : interfazes = clazz.getInterfaces()) {
            if (!producerName.equals(interfaze.getName())) continue;
            return interfaze.getClassLoader();
        }
        if (clazz.getSuperclass() == null) {
            return null;
        }
        return AbstractConfigProducer.findInheritedClassLoader(clazz.getSuperclass(), producerName);
    }

    protected ClassLoader getConfigClassLoader(String producerName) {
        ClassLoader classLoader = AbstractConfigProducer.findInheritedClassLoader(this.getClass(), producerName);
        if (classLoader != null) {
            return classLoader;
        }
        for (AbstractConfigProducer child : this.childrenBySubId.values()) {
            ClassLoader loader = child.getConfigClassLoader(producerName);
            if (loader == null) continue;
            return loader;
        }
        return null;
    }

    private void setupChildConfigIds(String currentConfigId) {
        for (AbstractConfigProducer child : this.childrenBySubId.values()) {
            child.setupConfigId(currentConfigId);
        }
    }

    void aggregateDescendantServices() {
        for (AbstractConfigProducer child : this.childrenBySubId.values()) {
            child.aggregateDescendantServices();
            this.descendantServices.addAll(child.descendantServices);
        }
    }

    void freeze() {
        this.childrenBySubId.freeze();
        for (AbstractConfigProducer child : this.childrenBySubId.values()) {
            child.freeze();
        }
    }

    public void mergeUserConfigs(UserConfigRepo newRepo) {
        this.userConfigs.merge(newRepo);
    }

    @Override
    public void validate() throws Exception {
        assert (this.childrenBySubId.isFrozen());
        for (AbstractConfigProducer child : this.childrenBySubId.values()) {
            child.validate();
        }
    }

    protected Monitoring getMonitoringService() {
        Admin admin;
        AbstractConfigProducerRoot root = this.getRoot();
        Admin admin2 = admin = root == null ? null : root.getAdmin();
        if (admin == null) {
            return null;
        }
        if (admin.getMonitoring() != null) {
            return admin.getMonitoring();
        }
        return null;
    }
}

