/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import java.util.Optional;
import org.w3c.dom.Element;

public class AccessLogBuilder {
    private static AccessLogComponent.AccessLogType logTypeFor(AccessLogTypeLiteral typeLiteral) {
        return switch (typeLiteral) {
            default -> throw new IncompatibleClassChangeError();
            case AccessLogTypeLiteral.DISABLED -> null;
            case AccessLogTypeLiteral.VESPA -> AccessLogComponent.AccessLogType.queryAccessLog;
            case AccessLogTypeLiteral.JSON -> AccessLogComponent.AccessLogType.jsonAccessLog;
        };
    }

    public static Optional<AccessLogComponent> buildIfNotDisabled(DeployState deployState, ContainerCluster<?> cluster, Element accessLogSpec) {
        AccessLogTypeLiteral typeLiteral = XmlHelper.getOptionalAttribute(accessLogSpec, "type").map(AccessLogTypeLiteral::fromAttributeValue).orElse(AccessLogTypeLiteral.JSON);
        AccessLogComponent.AccessLogType logType = AccessLogBuilder.logTypeFor(typeLiteral);
        if (logType == null) {
            return Optional.empty();
        }
        boolean hosted = cluster.isHostedVespa();
        return Optional.of((AccessLogComponent)new DomBuilder(logType, hosted).build(deployState, cluster, accessLogSpec));
    }

    private static enum AccessLogTypeLiteral {
        VESPA("vespa"),
        JSON("json"),
        DISABLED("disabled");

        final String attributeValue;

        private AccessLogTypeLiteral(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        static AccessLogTypeLiteral fromAttributeValue(String value) {
            return (AccessLogTypeLiteral)((Object)CollectionUtil.firstMatching((Object[])AccessLogTypeLiteral.values(), typeLiteral -> typeLiteral.attributeValue.equals(value)).get());
        }
    }

    private static class DomBuilder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<AccessLogComponent> {
        private final AccessLogComponent.AccessLogType accessLogType;
        private final boolean isHostedVespa;

        public DomBuilder(AccessLogComponent.AccessLogType accessLogType, boolean isHostedVespa) {
            this.accessLogType = accessLogType;
            this.isHostedVespa = isHostedVespa;
        }

        @Override
        protected AccessLogComponent doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element spec) {
            String fallback = deployState.featureFlags().logFileCompressionAlgorithm("zstd");
            return new AccessLogComponent(this.accessLogType, DomBuilder.compressionType(spec, fallback), this.fileNamePattern(spec), this.rotationInterval(spec), this.compressOnRotation(spec), this.isHostedVespa, this.symlinkName(spec), this.queueSize(spec), this.bufferSize(spec));
        }

        private String symlinkName(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("symlinkName"));
        }

        private Boolean compressOnRotation(Element spec) {
            String compress = spec.getAttribute("compressOnRotation");
            return compress.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(compress));
        }

        private Integer bufferSize(Element spec) {
            String value = spec.getAttribute("bufferSize");
            return value.isEmpty() ? null : Integer.valueOf(Integer.parseInt(value));
        }

        private Integer queueSize(Element spec) {
            String value = spec.getAttribute("queueSize");
            return value.isEmpty() ? null : Integer.valueOf(Integer.parseInt(value));
        }

        private String rotationInterval(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("rotationInterval"));
        }

        private String fileNamePattern(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("fileNamePattern"));
        }

        private static String compressionType(Element spec, String fallback) {
            return Optional.ofNullable(spec.getAttribute("compressionType")).filter(value -> !value.isBlank()).orElse(fallback);
        }
    }
}

