/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains.search;

import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.LocalProviderSpec;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomGenericTargetBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomSourceBuilder;
import com.yahoo.vespa.model.container.search.searchchain.GenericProvider;
import com.yahoo.vespa.model.container.search.searchchain.LocalProvider;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Element;

public class DomProviderBuilder
extends DomGenericTargetBuilder<Provider> {
    public DomProviderBuilder(Map<String, ComponentsBuilder.ComponentType<?>> outerSearcherTypeByComponentName) {
        super(outerSearcherTypeByComponentName);
    }

    @Override
    protected Provider buildChain(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element providerElement, ChainSpecification specWithoutInnerComponents) {
        ProviderReader providerReader = new ProviderReader(providerElement);
        FederationOptions federationOptions = DomProviderBuilder.readFederationOptions(providerElement);
        Provider provider = this.buildProvider(specWithoutInnerComponents, providerReader, federationOptions);
        Collection<Source> sources = this.buildSources(deployState, ancestor, providerElement);
        this.addSources(provider, sources);
        return provider;
    }

    private Collection<Source> buildSources(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element providerElement) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (Element sourceElement : XML.getChildren((Element)providerElement, (String)"source")) {
            sources.add((Source)new DomSourceBuilder(this.outerComponentTypeByComponentName).build(deployState, ancestor, sourceElement));
        }
        return sources;
    }

    private void addSources(Provider provider, Collection<Source> sources) {
        for (Source source : sources) {
            provider.addSource(source);
        }
    }

    private Provider buildProvider(ChainSpecification specWithoutInnerSearchers, ProviderReader providerReader, FederationOptions federationOptions) {
        if (providerReader.type == null) {
            return new GenericProvider(specWithoutInnerSearchers, federationOptions);
        }
        if (LocalProviderSpec.includesType((String)providerReader.type)) {
            return this.buildLocalProvider(specWithoutInnerSearchers, providerReader, federationOptions);
        }
        throw new IllegalArgumentException("Unknown provider type '" + providerReader.type + "'");
    }

    private Provider buildLocalProvider(ChainSpecification specWithoutInnerSearchers, ProviderReader providerReader, FederationOptions federationOptions) {
        try {
            return new LocalProvider(specWithoutInnerSearchers, federationOptions, new LocalProviderSpec(providerReader.clusterName));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creating local provider " + specWithoutInnerSearchers.componentId, e);
        }
    }

    private static class ProviderReader {
        final String type;
        final String clusterName;

        ProviderReader(Element providerElement) {
            this.type = this.readType(providerElement);
            this.clusterName = this.readCluster(providerElement);
        }

        private String getAttributeOrNull(Element element, String name) {
            String value = element.getAttribute(name);
            return value.isEmpty() ? null : value;
        }

        private String readCluster(Element providerElement) {
            return this.getAttributeOrNull(providerElement, "cluster");
        }

        private String readType(Element providerElement) {
            return this.getAttributeOrNull(providerElement, "type");
        }
    }

    public static class Node {
        public final String host;
        public final int port;

        public Node(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String toString() {
            return "Node{host='" + this.host + "', port=" + this.port + "}";
        }
    }
}

