/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.Ranking;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ValidateFieldWithIndexSettingsCreatesIndex
extends Processor {
    public ValidateFieldWithIndexSettingsCreatesIndex(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        Matching defaultMatching = new Matching();
        Ranking defaultRanking = new Ranking();
        for (SDField field : this.schema.allConcreteFields()) {
            if (field.doesIndexing() || field.doesAttributing()) continue;
            if (!field.getRanking().equals(defaultRanking)) {
                this.fail(this.schema, field, "Fields which are not creating an index or attribute can not contain rank settings.");
            }
            if (field.getMatching().equals(defaultMatching)) continue;
            this.fail(this.schema, field, "Fields which are not creating an index or attribute can not contain match settings.");
        }
    }
}

