/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AdjustSummaryTransforms
extends Processor {
    public AdjustSummaryTransforms(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            for (SummaryField summaryField : summary.getSummaryFields().values()) {
                this.makeDocumentIdTransformIfAppropriate(summaryField);
                this.makeAttributeTransformIfAppropriate(summaryField, this.schema);
                this.makeAttributeCombinerTransformIfAppropriate(summaryField, this.schema);
                this.makeAttributeTokensTransformIfAppropriate(summaryField, summary.getName(), this.schema);
                this.makeCopyTransformIfAppropriate(summaryField, this.schema);
            }
        }
    }

    private void makeDocumentIdTransformIfAppropriate(SummaryField summaryField) {
        if (summaryField.getName().equals("documentid")) {
            summaryField.setTransform(SummaryTransform.DOCUMENT_ID);
        }
    }

    private void makeAttributeTransformIfAppropriate(SummaryField summaryField, Schema schema) {
        if (summaryField.getTransform() != SummaryTransform.NONE) {
            return;
        }
        Attribute attribute = schema.getAttribute(summaryField.getSingleSource());
        if (attribute == null) {
            return;
        }
        summaryField.setTransform(SummaryTransform.ATTRIBUTE);
    }

    private void makeAttributeCombinerTransformIfAppropriate(SummaryField summaryField, Schema schema) {
        String sourceFieldName;
        ImmutableSDField source;
        if (summaryField.getTransform() == SummaryTransform.NONE && (source = schema.getField(sourceFieldName = summaryField.getSingleSource())) != null && ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(source)) {
            summaryField.setTransform(SummaryTransform.ATTRIBUTECOMBINER);
        }
    }

    private void makeAttributeTokensTransformIfAppropriate(SummaryField summaryField, String docsumName, Schema schema) {
        if (summaryField.getTransform() == SummaryTransform.TOKENS) {
            String sourceFieldName = summaryField.getSingleSource();
            Attribute attribute = schema.getAttribute(sourceFieldName);
            ImmutableSDField source = schema.getField(sourceFieldName);
            if (!source.doesIndexing()) {
                if (attribute != null) {
                    summaryField.setTransform(SummaryTransform.ATTRIBUTE_TOKENS);
                } else {
                    throw new IllegalArgumentException("For schema '" + schema.getName() + "', document-summary '" + docsumName + "', summary field '" + summaryField.getName() + "', source field '" + sourceFieldName + "': tokens summary field setting requires index or attribute for source field");
                }
            }
        }
    }

    private void makeCopyTransformIfAppropriate(SummaryField summaryField, Schema schema) {
        String sourceFieldName;
        ImmutableSDField source;
        if (summaryField.getTransform() == SummaryTransform.NONE && (source = schema.getField(sourceFieldName = summaryField.getSingleSource())) != null && source.usesStructOrMap() && summaryField.hasExplicitSingleSource()) {
            summaryField.setTransform(SummaryTransform.COPY);
        }
    }
}

