/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedSummaryField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParsedDocumentSummary
extends ParsedBlock {
    private boolean omitSummaryFeatures;
    private boolean fromDisk;
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, ParsedSummaryField> fields = new LinkedHashMap<String, ParsedSummaryField>();

    public ParsedDocumentSummary(String name) {
        super(name, "document-summary");
    }

    boolean getOmitSummaryFeatures() {
        return this.omitSummaryFeatures;
    }

    boolean getFromDisk() {
        return this.fromDisk;
    }

    List<ParsedSummaryField> getSummaryFields() {
        return List.copyOf(this.fields.values());
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    public ParsedSummaryField addField(ParsedSummaryField field) {
        String fieldName = field.name();
        this.verifyThat(!this.fields.containsKey(fieldName), "already has field", fieldName);
        return this.fields.put(fieldName, field);
    }

    public void setFromDisk(boolean value) {
        this.fromDisk = value;
    }

    public void setOmitSummaryFeatures(boolean value) {
        this.omitSummaryFeatures = value;
    }

    public void inherit(String other) {
        this.inherited.add(other);
    }
}

