/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.concurrent.InThreadExecutorService;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.ConfigDefinitionStore;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.provision.HostsXmlProvisioner;
import com.yahoo.config.model.provision.SingleNodeProvisioner;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.IOUtils;
import com.yahoo.schema.Application;
import com.yahoo.schema.ApplicationBuilder;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.container.search.QueryProfilesBuilder;
import com.yahoo.vespa.model.container.search.SemanticRules;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class DeployState
implements ConfigDefinitionStore {
    private final DeployLogger logger;
    private final FileRegistry fileRegistry;
    private final DocumentModel documentModel;
    private final List<Schema> schemas;
    private final ApplicationPackage applicationPackage;
    private final Optional<ConfigDefinitionRepo> configDefinitionRepo;
    private final Optional<Model> previousModel;
    private final boolean accessLoggingEnabledByDefault;
    private final ModelContext.Properties properties;
    private final Version vespaVersion;
    private final Set<ContainerEndpoint> endpoints;
    private final Zone zone;
    private final QueryProfiles queryProfiles;
    private final SemanticRules semanticRules;
    private final ImportedMlModels importedModels;
    private final ValidationOverrides validationOverrides;
    private final Version wantedNodeVespaVersion;
    private final Optional<DockerImage> wantedDockerImageRepo;
    private final Instant now;
    private final HostProvisioner provisioner;
    private final Provisioned provisioned;
    private final Reindexing reindexing;
    private final ExecutorService executor;
    private final OnnxModelCost onnxModelCost;
    private final RankProfileRegistry rankProfileRegistry;
    private Map<ConfigDefinitionKey, UnparsedConfigDefinition> configDefinitionSuppliers = null;
    private final Map<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition> configDefinitionCache = new LinkedHashMap<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition>();

    public static DeployState createTestState() {
        return new Builder().build();
    }

    public static DeployState createTestState(DeployLogger testLogger) {
        return new Builder().deployLogger(testLogger).build();
    }

    public static DeployState createTestState(ApplicationPackage applicationPackage) {
        return new Builder().applicationPackage(applicationPackage).build();
    }

    private DeployState(Application application, RankProfileRegistry rankProfileRegistry, FileRegistry fileRegistry, ExecutorService executor, DeployLogger deployLogger, Optional<HostProvisioner> hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Version vespaVersion, Optional<ConfigDefinitionRepo> configDefinitionRepo, Optional<Model> previousModel, Set<ContainerEndpoint> endpoints, Collection<MlModelImporter> modelImporters, Zone zone, QueryProfiles queryProfiles, SemanticRules semanticRules, Instant now, Version wantedNodeVespaVersion, boolean accessLoggingEnabledByDefault, Optional<DockerImage> wantedDockerImageRepo, Reindexing reindexing, Optional<ValidationOverrides> validationOverrides, OnnxModelCost onnxModelCost) {
        this.logger = deployLogger;
        this.fileRegistry = fileRegistry;
        this.executor = executor;
        this.rankProfileRegistry = rankProfileRegistry;
        this.applicationPackage = application.applicationPackage();
        this.properties = properties;
        this.vespaVersion = vespaVersion;
        this.previousModel = previousModel;
        this.accessLoggingEnabledByDefault = accessLoggingEnabledByDefault;
        this.provisioner = hostProvisioner.orElse(DeployState.getDefaultModelHostProvisioner(this.applicationPackage));
        this.provisioned = provisioned;
        this.schemas = List.copyOf(application.schemas().values());
        this.documentModel = application.documentModel();
        this.configDefinitionRepo = configDefinitionRepo;
        this.endpoints = Set.copyOf(endpoints);
        this.zone = zone;
        this.queryProfiles = queryProfiles;
        this.semanticRules = semanticRules;
        this.importedModels = DeployState.importMlModels(this.applicationPackage, modelImporters, executor);
        this.validationOverrides = validationOverrides.orElse(this.applicationPackage.getValidationOverrides().map(ValidationOverrides::fromXml).orElse(ValidationOverrides.empty));
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
        this.now = now;
        this.wantedDockerImageRepo = wantedDockerImageRepo;
        this.reindexing = reindexing;
        this.onnxModelCost = onnxModelCost;
    }

    public static HostProvisioner getDefaultModelHostProvisioner(ApplicationPackage applicationPackage) {
        Object object;
        block8: {
            Reader hostsReader = applicationPackage.getHosts();
            try {
                Object object2 = object = hostsReader == null ? new SingleNodeProvisioner() : new HostsXmlProvisioner(hostsReader);
                if (hostsReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hostsReader != null) {
                        try {
                            hostsReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read hosts.xml", e);
                }
            }
            hostsReader.close();
        }
        return object;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public final RankProfileRegistry rankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public ValidationOverrides validationOverrides() {
        return this.validationOverrides;
    }

    @Override
    public final Optional<com.yahoo.vespa.config.ConfigDefinition> getConfigDefinition(ConfigDefinitionKey defKey) {
        if (this.configDefinitionSuppliers == null) {
            this.configDefinitionSuppliers = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
            this.configDefinitionRepo.ifPresent(definitionRepo -> this.configDefinitionSuppliers.putAll(DeployState.createLazyMapping(definitionRepo)));
            this.configDefinitionSuppliers.putAll(this.applicationPackage.getAllExistingConfigDefs());
        }
        if (!this.configDefinitionSuppliers.containsKey(defKey)) {
            return Optional.empty();
        }
        if (this.configDefinitionCache.get(defKey) != null) {
            return Optional.of(this.configDefinitionCache.get(defKey));
        }
        com.yahoo.vespa.config.ConfigDefinition def = this.configDefinitionSuppliers.get(defKey).parse();
        this.configDefinitionCache.put(defKey, def);
        return Optional.of(def);
    }

    private static Map<ConfigDefinitionKey, UnparsedConfigDefinition> createLazyMapping(final ConfigDefinitionRepo configDefinitionRepo) {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> keyToRepo = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        for (final Map.Entry defEntry : configDefinitionRepo.getConfigDefinitions().entrySet()) {
            keyToRepo.put((ConfigDefinitionKey)defEntry.getKey(), new UnparsedConfigDefinition(){

                public com.yahoo.vespa.config.ConfigDefinition parse() {
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)((ConfigDefinition)configDefinitionRepo.getConfigDefinitions().get(defEntry.getKey())).getCNode());
                }

                public String getUnparsedContent() {
                    throw new UnsupportedOperationException("Cannot get unparsed content from " + defEntry.getKey());
                }
            });
        }
        return keyToRepo;
    }

    private static ImportedMlModels importMlModels(ApplicationPackage applicationPackage, Collection<MlModelImporter> modelImporters, ExecutorService executor) {
        File importFrom = applicationPackage.getFileReference(ApplicationPackage.MODELS_DIR);
        ImportedMlModels importedModels = new ImportedMlModels(importFrom, executor, modelImporters);
        Iterator iterator = importedModels.getSkippedModels().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            throw new IllegalArgumentException("Could not import model '" + (String)entry.getKey() + "': " + (String)entry.getValue());
        }
        return importedModels;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public List<Schema> getSchemas() {
        return this.schemas;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public DeployLogger getDeployLogger() {
        return this.logger;
    }

    public boolean getAccessLoggingEnabledByDefault() {
        return this.accessLoggingEnabledByDefault;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public HostProvisioner getProvisioner() {
        return this.provisioner;
    }

    public ModelContext.Properties getProperties() {
        return this.properties;
    }

    public ModelContext.FeatureFlags featureFlags() {
        return this.properties.featureFlags();
    }

    public Version getVespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Model> getPreviousModel() {
        return this.previousModel;
    }

    public boolean isHosted() {
        return this.properties.hostedVespa();
    }

    public Set<ContainerEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public Zone zone() {
        return this.zone;
    }

    public QueryProfiles getQueryProfiles() {
        return this.queryProfiles;
    }

    public SemanticRules getSemanticRules() {
        return this.semanticRules;
    }

    public ImportedMlModels getImportedModels() {
        return this.importedModels;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Version getWantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public Optional<DockerImage> getWantedDockerImageRepo() {
        return this.wantedDockerImageRepo;
    }

    public Instant now() {
        return this.now;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.properties.endpointCertificateSecrets();
    }

    public Optional<String> tlsClientAuthority() {
        ApplicationFile caFile = this.applicationPackage.getClientSecurityFile();
        if (caFile.exists()) {
            try {
                String caPem = IOUtils.readAll((Reader)caFile.createReader());
                return Optional.of(caPem);
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed reading certificate from application: " + caFile.getPath(), e);
            }
        }
        return Optional.empty();
    }

    public Optional<Reindexing> reindexing() {
        return Optional.ofNullable(this.reindexing);
    }

    public OnnxModelCost onnxModelCost() {
        return this.onnxModelCost;
    }

    public boolean isHostedTenantApplication(ConfigModelContext.ApplicationType type) {
        boolean isTesterApplication = this.getProperties().applicationId().instance().isTester();
        return this.isHosted() && type == ConfigModelContext.ApplicationType.DEFAULT && !isTesterApplication;
    }

    public static class Builder {
        private ApplicationPackage applicationPackage = MockApplicationPackage.createEmpty();
        private FileRegistry fileRegistry = new MockFileRegistry();
        private ExecutorService executor = new InThreadExecutorService();
        private DeployLogger logger = new BaseDeployLogger();
        private Optional<HostProvisioner> hostProvisioner = Optional.empty();
        private Provisioned provisioned = new Provisioned();
        private ModelContext.Properties properties = new TestProperties();
        private Version version = new Version(1, 0, 0);
        private Optional<ConfigDefinitionRepo> configDefinitionRepo = Optional.empty();
        private Optional<Model> previousModel = Optional.empty();
        private Set<ContainerEndpoint> endpoints = Set.of();
        private Collection<MlModelImporter> modelImporters = List.of();
        private Zone zone = Zone.defaultZone();
        private Instant now = Instant.now();
        private Version wantedNodeVespaVersion = Vtag.currentVersion;
        private boolean accessLoggingEnabledByDefault = true;
        private Optional<DockerImage> wantedDockerImageRepo = Optional.empty();
        private RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
        private QueryProfiles queryProfiles = null;
        private Reindexing reindexing = null;
        private Optional<ValidationOverrides> validationOverrides = Optional.empty();
        private OnnxModelCost onnxModelCost = OnnxModelCost.disabled();

        public Builder applicationPackage(ApplicationPackage applicationPackage) {
            this.applicationPackage = applicationPackage;
            return this;
        }

        public Builder fileRegistry(FileRegistry fileRegistry) {
            this.fileRegistry = fileRegistry;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder deployLogger(DeployLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder modelHostProvisioner(HostProvisioner modelProvisioner) {
            this.hostProvisioner = Optional.of(modelProvisioner);
            return this;
        }

        public Builder provisioned(Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public Builder properties(ModelContext.Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder vespaVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder configDefinitionRepo(ConfigDefinitionRepo configDefinitionRepo) {
            this.configDefinitionRepo = Optional.of(configDefinitionRepo);
            return this;
        }

        public Builder previousModel(Model previousModel) {
            this.previousModel = Optional.of(previousModel);
            return this;
        }

        public Builder endpoints(Set<ContainerEndpoint> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder modelImporters(Collection<MlModelImporter> modelImporters) {
            this.modelImporters = modelImporters;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder now(Instant now) {
            this.now = now;
            return this;
        }

        public Builder wantedNodeVespaVersion(Version version) {
            this.wantedNodeVespaVersion = version;
            return this;
        }

        public Builder wantedDockerImageRepo(Optional<DockerImage> dockerImageRepo) {
            this.wantedDockerImageRepo = dockerImageRepo;
            return this;
        }

        public Builder accessLoggingEnabledByDefault(boolean accessLoggingEnabledByDefault) {
            this.accessLoggingEnabledByDefault = accessLoggingEnabledByDefault;
            return this;
        }

        public Builder rankProfileRegistry(RankProfileRegistry rankProfileRegistry) {
            this.rankProfileRegistry = rankProfileRegistry;
            return this;
        }

        public Builder queryProfiles(QueryProfiles queryProfiles) {
            this.queryProfiles = queryProfiles;
            return this;
        }

        public Builder queryProfiles(QueryProfileRegistry queryProfileRegistry) {
            this.queryProfiles = new QueryProfiles(queryProfileRegistry, this.logger);
            return this;
        }

        public Builder reindexing(Reindexing reindexing) {
            this.reindexing = Objects.requireNonNull(reindexing);
            return this;
        }

        public Builder validationOverrides(ValidationOverrides validationOverrides) {
            this.validationOverrides = Optional.of(validationOverrides);
            return this;
        }

        public Builder onnxModelCost(OnnxModelCost instance) {
            this.onnxModelCost = instance;
            return this;
        }

        public DeployState build() {
            return this.build(new ValidationParameters());
        }

        public DeployState build(ValidationParameters validationParameters) {
            if (this.queryProfiles == null) {
                this.queryProfiles = new QueryProfilesBuilder().build(this.applicationPackage, this.logger);
            }
            SemanticRules semanticRules = new SemanticRules.SemanticRuleBuilder().build(this.applicationPackage);
            Application application = new ApplicationBuilder(this.applicationPackage, this.fileRegistry, this.logger, this.properties, this.rankProfileRegistry, this.queryProfiles.getRegistry()).build(!validationParameters.ignoreValidationErrors());
            return new DeployState(application, this.rankProfileRegistry, this.fileRegistry, this.executor, this.logger, this.hostProvisioner, this.provisioned, this.properties, this.version, this.configDefinitionRepo, this.previousModel, this.endpoints, this.modelImporters, this.zone, this.queryProfiles, semanticRules, this.now, this.wantedNodeVespaVersion, this.accessLoggingEnabledByDefault, this.wantedDockerImageRepo, this.reindexing, this.validationOverrides, this.onnxModelCost);
        }
    }
}

