/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ModelConfigTransformer {
    private static final Map<String, String> providedModels = Map.of("minilm-l6-v2", "https://data.vespa.oath.cloud/onnx_models/sentence_all_MiniLM_L6_v2.onnx", "bert-base-uncased", "https://data.vespa.oath.cloud/onnx_models/bert-base-uncased-vocab.txt");
    private static final String dummyPath = "services.xml";

    public static Element transform(DeployState deployState, Element component) {
        for (Element config : XML.getChildren((Element)component, (String)"config")) {
            for (Element value : XML.getChildren((Element)config)) {
                ModelConfigTransformer.transformModelValue(value, config, deployState.isHosted());
            }
        }
        return component;
    }

    private static void transformModelValue(Element value, Element config, boolean hosted) {
        if (value.hasAttribute("path")) {
            ModelConfigTransformer.addChild(value.getTagName() + "Url", "", config);
            ModelConfigTransformer.addChild(value.getTagName() + "Path", value.getAttribute("path"), config);
            config.removeChild(value);
        } else if (value.hasAttribute("id") && hosted) {
            ModelConfigTransformer.addChild(value.getTagName() + "Url", ModelConfigTransformer.modelIdToUrl(value.getAttribute("id")), config);
            ModelConfigTransformer.addChild(value.getTagName() + "Path", dummyPath, config);
            config.removeChild(value);
        } else if (value.hasAttribute("url")) {
            ModelConfigTransformer.addChild(value.getTagName() + "Url", value.getAttribute("url"), config);
            ModelConfigTransformer.addChild(value.getTagName() + "Path", dummyPath, config);
            config.removeChild(value);
        }
    }

    private static void addChild(String name, String value, Element parent) {
        Element element = parent.getOwnerDocument().createElement(name);
        element.setTextContent(value);
        parent.appendChild(element);
    }

    private static String modelIdToUrl(String id) {
        if (!providedModels.containsKey(id)) {
            throw new IllegalArgumentException("Unknown embedder model '" + id + "'. Available models are [" + providedModels.keySet().stream().sorted().collect(Collectors.joining(", ")) + "]");
        }
        return providedModels.get(id);
    }
}

