/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.identity.IdentityConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.net.URI;

public class IdentityProvider
extends SimpleComponent
implements IdentityConfig.Producer {
    public static final String CLASS = "com.yahoo.vespa.athenz.identityprovider.client.AthenzIdentityProviderImpl";
    public static final String BUNDLE = "vespa-athenz";
    private final AthenzDomain domain;
    private final AthenzService service;
    private final HostName loadBalancerName;
    private final URI ztsUrl;
    private final String athenzDnsSuffix;
    private final Zone zone;

    public IdentityProvider(AthenzDomain domain, AthenzService service, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, Zone zone) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)CLASS, (String)CLASS, (String)BUNDLE)));
        this.domain = domain;
        this.service = service;
        this.loadBalancerName = loadBalancerName;
        this.ztsUrl = ztsUrl;
        this.athenzDnsSuffix = athenzDnsSuffix;
        this.zone = zone;
    }

    public void getConfig(IdentityConfig.Builder builder) {
        builder.domain(this.domain.value());
        builder.service(this.service.value());
        builder.loadBalancerAddress(this.loadBalancerName.value());
        builder.ztsUrl(this.ztsUrl != null ? this.ztsUrl.toString() : "");
        builder.athenzDnsSuffix(this.athenzDnsSuffix != null ? this.athenzDnsSuffix : "");
        builder.nodeIdentityName("vespa.vespa.tenant");
        builder.configserverIdentityName(this.getConfigserverIdentityName());
    }

    private String getConfigserverIdentityName() {
        return String.format("%s.provider_%s_%s", this.zone.system() == SystemName.main ? "vespa.vespa" : "vespa.vespa.cd", this.zone.environment().value(), this.zone.region().value());
    }
}

