/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;

public class AccessControlFilterValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        model.getContainerClusters().forEach((id, cluster) -> {
            Http http = cluster.getHttp();
            if (http != null && http.getAccessControl().isPresent()) {
                AccessControlFilterValidator.verifyAccessControlFilterPresent(http);
            }
        });
    }

    private static void verifyAccessControlFilterPresent(Http http) {
        FilterChains filterChains = http.getFilterChains();
        Chain chain = (Chain)filterChains.allChains().getComponent(AccessControl.ACCESS_CONTROL_CHAIN_ID);
        if (chain.getInnerComponents().isEmpty()) {
            throw new IllegalArgumentException("The 'access-control' feature is not available in open-source Vespa.");
        }
    }
}

