/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.graph;

import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.graph.ModelGraph;
import com.yahoo.config.model.graph.ModelNode;
import java.util.ArrayList;
import java.util.List;

public class ModelGraphBuilder {
    private final List<ConfigModelBuilder<? extends ConfigModel>> builders = new ArrayList<ConfigModelBuilder<? extends ConfigModel>>();

    public ModelGraphBuilder addBuilder(ConfigModelBuilder<? extends ConfigModel> builder) {
        this.builders.add(builder);
        return this;
    }

    public ModelGraph build() {
        ArrayList<ModelNode> modelNodes = new ArrayList<ModelNode>();
        for (ConfigModelBuilder<? extends ConfigModel> builder : this.builders) {
            modelNodes.add(new ModelNode<ConfigModel>(builder));
        }
        ArrayList<ModelNode> roots = new ArrayList<ModelNode>();
        for (ModelNode modelNode : modelNodes) {
            int numDependencies = modelNode.addDependenciesFrom(modelNodes);
            if (numDependencies != 0) continue;
            roots.add(modelNode);
        }
        return new ModelGraph(modelNodes, roots);
    }
}

