/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import org.w3c.dom.Element;

public class EmbedderConfigTransformer {
    private static final String dummyPath = "services.xml";

    public static Element transform(DeployState deployState, Element embedder) {
        Element component = XML.getDocumentBuilder().newDocument().createElement("component");
        component.setAttribute("id", embedder.getAttribute("id"));
        component.setAttribute("class", EmbedderConfigTransformer.embedderClassFrom(embedder));
        component.setAttribute("bundle", embedder.hasAttribute("bundle") ? embedder.getAttribute("bundle") : "model-integration");
        String configDef = EmbedderConfigTransformer.embedderConfigFrom(embedder);
        if (!configDef.isEmpty()) {
            Element config = component.getOwnerDocument().createElement("config");
            config.setAttribute("name", configDef);
            for (Element child : XML.getChildren((Element)embedder)) {
                EmbedderConfigTransformer.addConfigValue(child, config, deployState.isHosted());
            }
            component.appendChild(config);
        }
        return component;
    }

    private static void addConfigValue(Element value, Element config, boolean hosted) {
        if (value.hasAttribute("path")) {
            EmbedderConfigTransformer.addChild(value.getTagName() + "Url", "", config);
            EmbedderConfigTransformer.addChild(value.getTagName() + "Path", value.getAttribute("path"), config);
        } else if (value.hasAttribute("id") && hosted) {
            EmbedderConfigTransformer.addChild(value.getTagName() + "Url", EmbedderConfigTransformer.modelIdToUrl(value.getAttribute("id")), config);
            EmbedderConfigTransformer.addChild(value.getTagName() + "Path", dummyPath, config);
        } else if (value.hasAttribute("url")) {
            EmbedderConfigTransformer.addChild(value.getTagName() + "Url", value.getAttribute("url"), config);
            EmbedderConfigTransformer.addChild(value.getTagName() + "Path", dummyPath, config);
        } else {
            EmbedderConfigTransformer.addChild(value.getTagName(), value.getTextContent(), config);
        }
    }

    private static void addChild(String name, String value, Element parent) {
        Element element = parent.getOwnerDocument().createElement(name);
        element.setTextContent(value);
        parent.appendChild(element);
    }

    private static String embedderConfigFrom(Element spec) {
        String explicitDefinition = spec.getAttribute("def");
        if (!explicitDefinition.isEmpty()) {
            return explicitDefinition;
        }
        return switch (EmbedderConfigTransformer.embedderClassFrom(spec)) {
            case "ai.vespa.embedding.BertBaseEmbedder" -> "embedding.bert-base-embedder";
            default -> "";
        };
    }

    private static String modelIdToUrl(String id) {
        switch (id) {
            case "test-model-id": {
                return "test-model-url";
            }
            case "minilm-l6-v2": {
                return "https://data.vespa.oath.cloud/onnx_models/sentence_all_MiniLM_L6_v2.onnx";
            }
            case "bert-base-uncased": {
                return "https://data.vespa.oath.cloud/onnx_models/bert-base-uncased-vocab.txt";
            }
        }
        throw new IllegalArgumentException("Unknown model id '" + id + "'");
    }

    private static String embedderClassFrom(Element spec) {
        if (spec.hasAttribute("class")) {
            return spec.getAttribute("class");
        }
        if (spec.hasAttribute("id")) {
            return spec.getAttribute("id");
        }
        throw new IllegalArgumentException("An <embedder> element must have a 'class' or 'id' attribute");
    }
}

