/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SummaryConsistency
extends Processor {
    public SummaryConsistency(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            if (summary.getName().equals("default")) continue;
            for (SummaryField summaryField : summary.getSummaryFields().values()) {
                this.assertConsistency(summaryField, this.schema, validate);
            }
        }
    }

    private void assertConsistency(SummaryField summaryField, Schema schema, boolean validate) {
        SummaryField existingDefault = schema.getSummariesInThis().get("default").getSummaryField(summaryField.getName());
        if (existingDefault != null) {
            if (validate) {
                this.assertConsistentTypes(existingDefault, summaryField);
            }
            this.makeConsistentWithDefaultOrThrow(existingDefault, summaryField);
        } else {
            SummaryField existing = schema.getExplicitSummaryField(summaryField.getName());
            if (existing == null) {
                return;
            }
            if (validate) {
                this.assertConsistentTypes(existing, summaryField);
            }
            this.makeConsistentOrThrow(existing, summaryField, schema);
        }
    }

    private void assertConsistentTypes(SummaryField existing, SummaryField seen) {
        if (existing.getDataType() instanceof WeightedSetDataType && seen.getDataType() instanceof WeightedSetDataType && ((WeightedSetDataType)existing.getDataType()).getNestedType().equals((Object)((WeightedSetDataType)seen.getDataType()).getNestedType())) {
            return;
        }
        if (!this.compatibleTypes(seen.getDataType(), existing.getDataType())) {
            throw new IllegalArgumentException(existing.toLocateString() + " is inconsistent with " + seen.toLocateString() + ": All declarations of the same summary field must have the same type");
        }
    }

    private boolean compatibleTypes(DataType summaryType, DataType existingType) {
        if (summaryType instanceof TensorDataType && existingType instanceof TensorDataType) {
            return summaryType.isAssignableFrom(existingType);
        }
        return summaryType.equals((Object)existingType);
    }

    private void makeConsistentOrThrow(SummaryField field1, SummaryField field2, Schema schema) {
        Attribute attribute;
        if (field2.getTransform() == SummaryTransform.ATTRIBUTE && field1.getTransform() == SummaryTransform.NONE && (attribute = schema.getAttribute(field1.getName())) != null) {
            field1.setTransform(SummaryTransform.ATTRIBUTE);
        }
        if (field2.getTransform().equals((Object)SummaryTransform.NONE)) {
            field2.setTransform(field1.getTransform());
        } else {
            this.assertEqualTransform(field1, field2);
        }
    }

    private void makeConsistentWithDefaultOrThrow(SummaryField defaultField, SummaryField newField) {
        if (newField.getTransform().equals((Object)SummaryTransform.NONE)) {
            newField.setTransform(defaultField.getTransform());
        } else {
            this.assertEqualTransform(defaultField, newField);
        }
    }

    private void assertEqualTransform(SummaryField field1, SummaryField field2) {
        if (!field2.getTransform().equals((Object)field1.getTransform())) {
            throw new IllegalArgumentException("Conflicting summary transforms. " + field2 + " is already defined as " + field1 + ". A field with the same name can not have different transforms in different summary classes");
        }
    }
}

