/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Map;

public class MatchedElementsOnlyResolver
extends Processor {
    public MatchedElementsOnlyResolver(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (Map.Entry<String, DocumentSummary> entry : this.schema.getSummaries().entrySet()) {
            DocumentSummary summary = entry.getValue();
            for (SummaryField field : summary.getSummaryFields().values()) {
                if (field.getTransform() != SummaryTransform.MATCHED_ELEMENTS_FILTER) continue;
                this.processSummaryField(summary, field, validate);
            }
        }
    }

    private void processSummaryField(DocumentSummary summary, SummaryField field, boolean validate) {
        ImmutableSDField sourceField = this.schema.getField(field.getSingleSource());
        if (sourceField != null) {
            if (ComplexAttributeFieldUtils.isSupportedComplexField(sourceField)) {
                if (ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(sourceField)) {
                    field.setTransform(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER);
                }
            } else if (this.isSupportedMultiValueField(sourceField)) {
                if (sourceField.doesAttributing()) {
                    field.setTransform(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER);
                }
            } else if (validate) {
                this.fail(summary, field, "'matched-elements-only' is not supported for this field type. Supported field types are: array of primitive, weighted set of primitive, array of simple struct, map of primitive type to simple struct, and map of primitive type to primitive type");
            }
        }
    }

    private boolean isSupportedMultiValueField(ImmutableSDField sourceField) {
        DataType type = sourceField.getDataType();
        return this.isArrayOfPrimitiveType(type) || this.isWeightedsetOfPrimitiveType(type);
    }

    private boolean isArrayOfPrimitiveType(DataType type) {
        if (type instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)type;
            return ComplexAttributeFieldUtils.isPrimitiveType(arrayType.getNestedType());
        }
        return false;
    }

    private boolean isWeightedsetOfPrimitiveType(DataType type) {
        if (type instanceof WeightedSetDataType) {
            WeightedSetDataType wsetType = (WeightedSetDataType)type;
            return ComplexAttributeFieldUtils.isPrimitiveType(wsetType.getNestedType());
        }
        return false;
    }

    private void fail(DocumentSummary summary, SummaryField field, String msg) {
        throw new IllegalArgumentException(this.formatError(this.schema, summary, field, msg));
    }

    private String formatError(Schema schema, DocumentSummary summary, SummaryField field, String msg) {
        return "For " + schema + ", document-summary '" + summary.getName() + "', summary field '" + field.getName() + "': " + msg;
    }
}

