/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml.embedder;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.container.xml.embedder.EmbedderConfigBertBaseTransformer;
import com.yahoo.vespa.model.container.xml.embedder.EmbedderConfigTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbedderConfig {
    static EmbedderConfigTransformer getEmbedderTransformer(Element spec, boolean hosted) {
        String classId;
        switch (classId = EmbedderConfig.getEmbedderClass(spec)) {
            case "ai.vespa.embedding.BertBaseEmbedder": {
                return new EmbedderConfigBertBaseTransformer(spec, hosted);
            }
        }
        return new EmbedderConfigTransformer(spec, hosted);
    }

    static String modelIdToUrl(String id) {
        switch (id) {
            case "test-model-id": {
                return "test-model-url";
            }
            case "minilm-l6-v2": {
                return "https://data.vespa.oath.cloud/onnx_models/sentence_all_MiniLM_L6_v2.onnx";
            }
            case "bert-base-uncased": {
                return "https://data.vespa.oath.cloud/onnx_models/bert-base-uncased-vocab.txt";
            }
        }
        throw new IllegalArgumentException("Unknown model id: '" + id + "'");
    }

    public static Element transform(DeployState deployState, Element embedderSpec) {
        EmbedderConfigTransformer transformer = EmbedderConfig.getEmbedderTransformer(embedderSpec, deployState.isHosted());
        NodeList children = embedderSpec.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            transformer.addOption((Element)child);
        }
        return transformer.createComponentConfig(deployState);
    }

    private static String getEmbedderClass(Element spec) {
        if (spec.hasAttribute("class")) {
            return spec.getAttribute("class");
        }
        if (spec.hasAttribute("id")) {
            return spec.getAttribute("id");
        }
        throw new IllegalArgumentException("Embedder specification does not have a required class attribute");
    }
}

