/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.parser.ParsedBlock;
import java.util.Optional;

class ParsedSorting
extends ParsedBlock {
    private boolean ascending = true;
    private Sorting.Function sortFunction = null;
    private Sorting.Strength sortStrength = null;
    private String sortLocale = null;

    ParsedSorting(String blockName, String blockType) {
        super(blockName, blockType);
    }

    boolean getAscending() {
        return this.ascending;
    }

    boolean getDescending() {
        return !this.ascending;
    }

    Optional<Sorting.Function> getFunction() {
        return Optional.ofNullable(this.sortFunction);
    }

    Optional<Sorting.Strength> getStrength() {
        return Optional.ofNullable(this.sortStrength);
    }

    Optional<String> getLocale() {
        return Optional.ofNullable(this.sortLocale);
    }

    void setAscending() {
        this.ascending = true;
    }

    void setDescending() {
        this.ascending = false;
    }

    void setLocale(String value) {
        this.verifyThat(this.sortLocale == null, "sorting already has locale", this.sortLocale);
        this.sortLocale = value;
    }

    void setFunction(Sorting.Function value) {
        this.verifyThat(this.sortFunction == null, "sorting already has function", new Object[]{this.sortFunction});
        this.sortFunction = value;
    }

    void setStrength(Sorting.Strength value) {
        this.verifyThat(this.sortStrength == null, "sorting already has strength", new Object[]{this.sortStrength});
        this.sortStrength = value;
    }
}

