/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BindingPattern
implements Comparable<BindingPattern> {
    private static final Pattern BINDING_PATTERN = Pattern.compile("([^:]+)://([^:/]+)(:((\\*)|([0-9]+)))?(/.*)", 192);
    public static final String WILDCARD_PATTERN = "*";
    private final String scheme;
    private final String host;
    private final String port;
    private final String path;

    protected BindingPattern(String scheme, String host, String port, String path) {
        this.scheme = Objects.requireNonNull(scheme, "Scheme in binding must be specified");
        this.host = Objects.requireNonNull(host, "Host must be specified");
        this.port = port;
        this.path = BindingPattern.validatePath(path);
    }

    protected BindingPattern(String binding) {
        Matcher matcher = BINDING_PATTERN.matcher(binding);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid binding: " + binding);
        }
        this.scheme = matcher.group(1);
        this.host = matcher.group(2);
        this.port = matcher.group(4);
        this.path = matcher.group(7);
    }

    private static String validatePath(String path) {
        Objects.requireNonNull(path, "Path must be specified");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must have '/' as prefix: " + path);
        }
        return path;
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public Optional<String> port() {
        return Optional.ofNullable(this.port);
    }

    public String path() {
        return this.path;
    }

    public String patternString() {
        StringBuilder builder = new StringBuilder(this.scheme).append("://").append(this.host);
        if (this.port != null) {
            builder.append(':').append(this.port);
        }
        return builder.append(this.path).toString();
    }

    public String originalPatternString() {
        StringBuilder builder = new StringBuilder(this.scheme).append("://").append(this.host);
        this.originalPort().ifPresent(port -> builder.append(':').append((String)port));
        return builder.append(this.path).toString();
    }

    public boolean hasSamePattern(BindingPattern other) {
        return this.patternString().equals(other.patternString());
    }

    public boolean matchesAnyPort() {
        return this.originalPort().filter(p -> !p.equals(WILDCARD_PATTERN)).isEmpty();
    }

    public Optional<String> originalPort() {
        return this.port();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindingPattern that = (BindingPattern)o;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.path);
    }

    @Override
    public int compareTo(BindingPattern o) {
        return Comparator.comparing(BindingPattern::scheme).thenComparing(BindingPattern::host).thenComparing(pattern -> pattern.port().orElse(null)).thenComparing(BindingPattern::path).compare(this, o);
    }
}

