/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.TensorDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.NormalizeLevel;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedList;
import java.util.logging.Level;

public class FieldSetSettings
extends Processor {
    private static String fieldSetDocUrl = "https://docs.vespa.ai/en/reference/schema-reference.html#fieldset";

    public FieldSetSettings(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (FieldSet fieldSet : this.schema.fieldSets().userFieldSets().values()) {
            if (validate) {
                this.checkFieldNames(this.schema, fieldSet);
            }
            this.checkMatching(this.schema, fieldSet);
            this.checkNormalization(this.schema, fieldSet);
            this.checkStemming(this.schema, fieldSet);
            this.checkTypes(this.schema, fieldSet);
        }
    }

    private void checkFieldNames(Schema schema, FieldSet fieldSet) {
        for (String field : fieldSet.getFieldNames()) {
            if (schema.getField(field) != null) continue;
            throw new IllegalArgumentException("For " + schema + ": Field '" + field + "' in " + fieldSet + " does not exist.");
        }
    }

    private void checkMatching(Schema schema, FieldSet fieldSet) {
        Matching matching = fieldSet.getMatching();
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            Matching fieldMatching = field.getMatching();
            if (matching == null) {
                matching = fieldMatching;
                continue;
            }
            if (matching.equals(fieldMatching)) continue;
            this.warn(schema, field.asField(), "The matching settings for the fields in " + fieldSet + " are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
        fieldSet.setMatching(matching);
    }

    private void checkNormalization(Schema schema, FieldSet fieldSet) {
        NormalizeLevel.Level normalizing = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            NormalizeLevel.Level fieldNorm = field.getNormalizing().getLevel();
            if (normalizing == null) {
                normalizing = fieldNorm;
                continue;
            }
            if (normalizing.equals((Object)fieldNorm)) continue;
            this.warn(schema, field.asField(), "The normalization settings for the fields in " + fieldSet + " are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
    }

    private void checkStemming(Schema schema, FieldSet fieldSet) {
        Stemming stemming = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            Stemming fieldStemming = field.getStemming();
            if (stemming == null) {
                stemming = fieldStemming;
                continue;
            }
            if (stemming.equals((Object)fieldStemming)) continue;
            this.warn(schema, field.asField(), "The stemming settings for the fields in the fieldset '" + fieldSet.getName() + "' are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues.");
            return;
        }
    }

    private void checkTypes(Schema schema, FieldSet fieldSet) {
        LinkedList<String> tensorFields = new LinkedList<String>();
        LinkedList<String> nonTensorFields = new LinkedList<String>();
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            if (field.getDataType() instanceof TensorDataType) {
                tensorFields.add(field.getName());
                continue;
            }
            nonTensorFields.add(field.getName());
        }
        if (!tensorFields.isEmpty() && !nonTensorFields.isEmpty()) {
            String fullMsg = "For schema '" + schema.getName() + "', fieldset '" + fieldSet.getName() + "': Tensor fields ['" + String.join((CharSequence)"', '", tensorFields) + "'] cannot be mixed with non-tensor fields ['" + String.join((CharSequence)"', '", nonTensorFields) + "'] in the same fieldset. See " + fieldSetDocUrl;
            this.deployLogger.logApplicationPackage(Level.WARNING, fullMsg);
        }
    }
}

