/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Handler
extends Component<Component<?, ?>, ComponentModel> {
    private final Set<BindingPattern> serverBindings = new LinkedHashSet<BindingPattern>();
    private final List<BindingPattern> clientBindings = new ArrayList<BindingPattern>();
    public final boolean hasCustomThreadPool;

    public Handler(ComponentModel model) {
        this(model, null);
    }

    public Handler(ComponentModel model, ContainerThreadpool threadpool) {
        super(model);
        if (threadpool != null) {
            this.hasCustomThreadPool = true;
            this.addComponent(threadpool);
            this.inject(threadpool);
        } else {
            this.hasCustomThreadPool = false;
        }
    }

    public static Handler fromClassName(String className) {
        return new Handler(new ComponentModel(className, null, null, null));
    }

    public void addServerBindings(BindingPattern ... bindings) {
        this.serverBindings.addAll(Arrays.asList(bindings));
    }

    public void removeServerBinding(BindingPattern binding) {
        this.serverBindings.remove(binding);
    }

    public void addClientBindings(BindingPattern ... bindings) {
        this.clientBindings.addAll(Arrays.asList(bindings));
    }

    public final Set<BindingPattern> getServerBindings() {
        return Collections.unmodifiableSet(this.serverBindings);
    }

    public final List<BindingPattern> getClientBindings() {
        return Collections.unmodifiableList(this.clientBindings);
    }

    public static class DefaultHandlerThreadpool
    extends ContainerThreadpool {
        public DefaultHandlerThreadpool() {
            super("default-handler-common", null);
        }

        @Override
        public void setDefaultConfigValues(ContainerThreadpoolConfig.Builder builder) {
            builder.maxThreadExecutionTimeSeconds(190).keepAliveTime(5.0).maxThreads(-2).minThreads(-2).queueSize(-40);
        }
    }
}

