/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.builder.xml;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.text.XML;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlHelper {
    private static final Logger log = Logger.getLogger(XmlHelper.class.getPackage().toString());
    private static final String idReference = "idref";
    public static final DocumentBuilderFactory factory = XmlHelper.createDocumentBuilderFactory();

    private XmlHelper() {
    }

    public static String nullIfEmpty(String attribute) {
        if (attribute.isEmpty()) {
            return null;
        }
        return attribute;
    }

    public static String getIdString(Element element) {
        String idString = element.getAttribute("id");
        if (idString == null || idString.trim().equals("")) {
            idString = element.getAttribute(idReference);
        }
        if (idString == null || idString.trim().equals("")) {
            idString = element.getAttribute("ident");
        }
        return idString;
    }

    public static ComponentId getId(Element element) {
        return new ComponentId(XmlHelper.getIdString(element));
    }

    public static ComponentSpecification getIdRef(Element element) {
        return new ComponentSpecification(XmlHelper.getIdString(element));
    }

    public static Document getDocument(Reader reader) {
        return XmlHelper.getDocument(reader, "unknown source");
    }

    public static Document getDocument(Reader reader, String source) {
        Document doc;
        try {
            InputSource inputSource = new InputSource(reader);
            inputSource.setPublicId(source);
            doc = XmlHelper.getDocumentBuilder().parse(inputSource);
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        return doc;
    }

    public static List<String> splitAndDiscardEmpty(String field, String regex) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String t : field.split(regex)) {
            if (t.isEmpty()) continue;
            ret.add(t);
        }
        return ret;
    }

    public static List<String> spaceSeparatedSymbols(String field) {
        return XmlHelper.splitAndDiscardEmpty(field, " ");
    }

    public static Collection<String> spaceSeparatedSymbolsFromAttribute(Element spec, String name) {
        return XmlHelper.spaceSeparatedSymbols(spec.getAttribute(name));
    }

    public static Collection<String> valuesFromElements(Element parent, String elementName) {
        ArrayList<String> symbols = new ArrayList<String>();
        for (Element symbol : XML.getChildren((Element)parent, (String)elementName)) {
            symbols.add(XML.getValue((Element)symbol).trim());
        }
        return symbols;
    }

    public static boolean isReference(Element element) {
        return element.hasAttribute(idReference);
    }

    public static synchronized DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new CustomErrorHandler(log));
            log.log(Level.FINE, "XML parser now operational!");
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            log.log(Level.WARNING, "No XML parser available - " + e);
            return null;
        }
    }

    public static Optional<String> getOptionalAttribute(Element element, String name) {
        return Optional.ofNullable(element.getAttribute(name)).filter(s -> !s.isEmpty());
    }

    public static Optional<Element> getOptionalChild(Element parent, String childName) {
        return Optional.ofNullable(XML.getChild((Element)parent, (String)childName));
    }

    public static Optional<String> getOptionalChildValue(Element parent, String childName) {
        Element child = XML.getChild((Element)parent, (String)childName);
        if (child == null) {
            return Optional.empty();
        }
        if (child.getFirstChild() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(child.getFirstChild().getNodeValue());
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(false);
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return factory;
        }
        catch (ParserConfigurationException e) {
            log.log(Level.SEVERE, "Could not initialize XML parser", e);
            throw new RuntimeException(e);
        }
    }

    private static class CustomErrorHandler
    implements ErrorHandler {
        private final Logger logger;

        CustomErrorHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void warning(SAXParseException e) {
            this.logger.log(Level.WARNING, this.message(e));
        }

        @Override
        public void error(SAXParseException e) {
            throw new IllegalArgumentException(this.message(e));
        }

        @Override
        public void fatalError(SAXParseException e) {
            throw new IllegalArgumentException(this.message(e));
        }

        private String message(SAXParseException e) {
            String sourceId = e.getPublicId() == null ? "" : e.getPublicId();
            return "Invalid XML" + (String)(sourceId.isEmpty() ? " (unknown source)" : " in " + sourceId) + ": " + Exceptions.toMessageString((Throwable)e) + " [" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
        }
    }
}

