/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.schema.DefaultRankProfile;
import com.yahoo.schema.DocumentOnlySchema;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.UnrankedRankProfile;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.TemporaryImportedField;
import com.yahoo.schema.document.TemporaryImportedFields;
import com.yahoo.schema.parser.ConvertParsedFields;
import com.yahoo.schema.parser.ConvertParsedRanking;
import com.yahoo.schema.parser.ConvertParsedTypes;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedDocumentSummary;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedFieldSet;
import com.yahoo.schema.parser.ParsedIndex;
import com.yahoo.schema.parser.ParsedRankProfile;
import com.yahoo.schema.parser.ParsedSchema;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.schema.parser.ParsedSummaryField;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class ConvertParsedSchemas {
    private final List<ParsedSchema> orderedInput;
    private final DocumentTypeManager docMan;
    private final ApplicationPackage applicationPackage;
    private final FileRegistry fileRegistry;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;
    private final RankProfileRegistry rankProfileRegistry;
    private final boolean documentsOnly;
    private final ConvertParsedTypes typeConverter;
    private final Map<String, SDDocumentType> convertedDocuments = new LinkedHashMap<String, SDDocumentType>();
    private final Map<String, SDDocumentType> convertedStructs = new LinkedHashMap<String, SDDocumentType>();

    ConvertParsedSchemas(List<ParsedSchema> orderedInput, DocumentTypeManager documentTypeManager) {
        this(orderedInput, documentTypeManager, MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), true);
    }

    public ConvertParsedSchemas(List<ParsedSchema> orderedInput, DocumentTypeManager documentTypeManager, ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, boolean documentsOnly) {
        this.orderedInput = orderedInput;
        this.docMan = documentTypeManager;
        this.applicationPackage = applicationPackage;
        this.fileRegistry = fileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.rankProfileRegistry = rankProfileRegistry;
        this.documentsOnly = documentsOnly;
        this.typeConverter = new ConvertParsedTypes(orderedInput, this.docMan);
    }

    public List<Schema> convertToSchemas() {
        this.typeConverter.convert(false);
        ArrayList<Schema> resultList = new ArrayList<Schema>();
        for (ParsedSchema parsed : this.orderedInput) {
            Optional<String> inherited;
            List<String> inheritList = parsed.getInherited();
            if (inheritList.size() == 0) {
                inherited = Optional.empty();
            } else if (inheritList.size() == 1) {
                inherited = Optional.of(inheritList.get(0));
            } else {
                throw new IllegalArgumentException("schema " + parsed.name() + "cannot inherit more than once");
            }
            Schema schema = parsed.getDocumentWithoutSchema() ? new DocumentOnlySchema(this.applicationPackage, this.fileRegistry, this.deployLogger, this.properties) : new Schema(parsed.name(), this.applicationPackage, inherited, this.fileRegistry, this.deployLogger, this.properties);
            inherited.ifPresent(parentName -> {
                for (Schema possibleParent : resultList) {
                    if (!possibleParent.getName().equals(parentName)) continue;
                    schema.setInheritedSchema(possibleParent);
                }
            });
            this.convertSchema(schema, parsed);
            resultList.add(schema);
        }
        return resultList;
    }

    private void convertDocument(Schema schema, ParsedDocument parsed, ConvertParsedFields fieldConverter) {
        SDDocumentType document = new SDDocumentType(parsed.name());
        for (ParsedStruct struct : parsed.getStructs()) {
            SDDocumentType structProxy = fieldConverter.convertStructDeclaration(schema, document, struct);
            document.addType(structProxy);
        }
        for (String inherit : parsed.getInherited()) {
            SDDocumentType parent = this.convertedDocuments.get(inherit);
            assert (parent != null);
            document.inherit(parent);
        }
        for (ParsedAnnotation annotation : parsed.getAnnotations()) {
            fieldConverter.convertAnnotation(schema, document, annotation);
        }
        for (ParsedField field : parsed.getFields()) {
            SDField sdf = fieldConverter.convertDocumentField(schema, document, field);
            if (!field.hasIdOverride()) continue;
            document.setFieldId(sdf, field.idOverride());
        }
        this.convertedDocuments.put(parsed.name(), document);
        schema.addDocument(document);
    }

    private void convertDocumentSummary(Schema schema, ParsedDocumentSummary parsed, ConvertParsedTypes.TypeResolver typeContext, SummaryFieldTypeResolver sfResolver) {
        DocumentSummary docsum = new DocumentSummary(parsed.name(), schema);
        parsed.getInherited().forEach(inherited -> docsum.addInherited((String)inherited));
        if (parsed.getFromDisk()) {
            docsum.setFromDisk(true);
        }
        if (parsed.getOmitSummaryFeatures()) {
            docsum.setOmitSummaryFeatures(true);
        }
        for (ParsedSummaryField parsedField : parsed.getSummaryFields()) {
            ParsedType parsedType = parsedField.getType();
            if (parsedType != null) {
                DeployLogger log = schema.getDeployLogger();
                log.log(Level.WARNING, () -> "For schema '" + schema.getName() + "', document-summary '" + parsed.name() + "', summary field '" + parsedField.name() + "': Specifying the type is deprecated, ignored and will be an error in Vespa 9. Remove the type specification to silence this warning.");
            }
            DataType dataType = parsedType != null ? typeContext.resolveType(parsedType) : null;
            DataType existingType = sfResolver.resolve(parsed, parsedField);
            if (existingType != null) {
                if (dataType == null) {
                    dataType = existingType;
                } else if (!dataType.equals((Object)existingType) && dataType.getValueClass().equals(WeightedSet.class)) {
                    dataType = existingType;
                }
            }
            SummaryField summaryField = dataType == null ? SummaryField.createWithUnresolvedType(parsedField.name()) : new SummaryField(parsedField.name(), dataType);
            summaryField.setVsmCommand(SummaryField.VsmCommand.FLATTENSPACE);
            ConvertParsedFields.convertSummaryFieldSettings(summaryField, parsedField);
            docsum.add(summaryField);
        }
        schema.addSummary(docsum);
    }

    private void convertImportField(Schema schema, ParsedSchema.ImportedField f) {
        TemporaryImportedFields importedFields = schema.temporaryImportedFields().get();
        if (importedFields.hasField(f.asFieldName)) {
            throw new IllegalArgumentException("For schema '" + schema.getName() + "', import field as '" + f.asFieldName + "': Field already imported");
        }
        importedFields.add(new TemporaryImportedField(f.asFieldName, f.refFieldName, f.foreignFieldName));
    }

    private void convertFieldSet(Schema schema, ParsedFieldSet parsed) {
        String setName = parsed.name();
        for (String field : parsed.getFieldNames()) {
            schema.fieldSets().addUserFieldSetItem(setName, field);
        }
        for (String command : parsed.getQueryCommands()) {
            schema.fieldSets().userFieldSets().get(setName).queryCommands().add(command);
        }
        if (parsed.getMatchSettings().isPresent()) {
            SDField tmp = new SDField(setName, (DataType)DataType.STRING);
            ConvertParsedFields.convertMatchSettings(tmp, parsed.matchSettings());
            schema.fieldSets().userFieldSets().get(setName).setMatching(tmp.getMatching());
        }
    }

    private void convertSchema(Schema schema, ParsedSchema parsed) {
        if (parsed.hasStemming()) {
            schema.setStemming(parsed.getStemming());
        }
        parsed.getRawAsBase64().ifPresent(value -> schema.enableRawAsBase64((boolean)value));
        ConvertParsedTypes.TypeResolver typeContext = this.typeConverter.makeContext(parsed.getDocument());
        SummaryFieldTypeResolver sfResolver = new SummaryFieldTypeResolver(schema, parsed.getDocumentSummaries());
        ConvertParsedFields fieldConverter = new ConvertParsedFields(typeContext, this.convertedStructs);
        this.convertDocument(schema, parsed.getDocument(), fieldConverter);
        for (ParsedField field : parsed.getFields()) {
            fieldConverter.convertExtraField(schema, field);
        }
        for (ParsedIndex index : parsed.getIndexes()) {
            fieldConverter.convertExtraIndex(schema, index);
        }
        for (ParsedSchema.ImportedField importedField : parsed.getImportedFields()) {
            this.convertImportField(schema, importedField);
        }
        for (ParsedDocumentSummary docsum : parsed.getDocumentSummaries()) {
            this.convertDocumentSummary(schema, docsum, typeContext, sfResolver);
        }
        for (ParsedFieldSet fieldSet : parsed.getFieldSets()) {
            this.convertFieldSet(schema, fieldSet);
        }
        if (this.documentsOnly) {
            return;
        }
        for (RankProfile.Constant constant : parsed.getConstants()) {
            schema.add(constant);
        }
        for (OnnxModel onnxModel : parsed.getOnnxModels()) {
            schema.add(onnxModel);
        }
        this.rankProfileRegistry.add(new DefaultRankProfile(schema, this.rankProfileRegistry));
        this.rankProfileRegistry.add(new UnrankedRankProfile(schema, this.rankProfileRegistry));
        ConvertParsedRanking rankConverter = new ConvertParsedRanking(this.rankProfileRegistry);
        for (ParsedRankProfile rankProfile : parsed.getRankProfiles()) {
            rankConverter.convertRankProfile(schema, rankProfile);
        }
    }

    private class SummaryFieldTypeResolver {
        private final Schema schema;
        private final Map<String, ParsedSummaryField> summaryFields = new LinkedHashMap<String, ParsedSummaryField>();
        private static final String zCurveSuffix = new String("_zcurve");

        public SummaryFieldTypeResolver(Schema schema, List<ParsedDocumentSummary> parsed) {
            this.schema = schema;
            for (ParsedDocumentSummary docsum : parsed) {
                for (ParsedSummaryField field : docsum.getSummaryFields()) {
                    this.summaryFields.put(field.name(), field);
                }
            }
        }

        private boolean isPositionAttribute(Schema schema, String sourceFieldName) {
            if (!sourceFieldName.endsWith(zCurveSuffix)) {
                return false;
            }
            String name = sourceFieldName.substring(0, sourceFieldName.length() - zCurveSuffix.length());
            ImmutableSDField field = schema.getField(name);
            return field.getDataType().equals((Object)PositionDataType.INSTANCE);
        }

        private String getSingleSource(ParsedSummaryField parsedField) {
            if (parsedField.getSources().size() == 1) {
                return parsedField.getSources().get(0);
            }
            return parsedField.name();
        }

        public DataType resolve(ParsedDocumentSummary docsum, ParsedSummaryField parsedField) {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            String origName = parsedField.name();
            while (true) {
                if (seen.contains(parsedField.name())) {
                    throw new IllegalArgumentException("For schema '" + this.schema.getName() + "' document-summary '" + docsum.name() + "' summary field '" + origName + "': Source loop detected for summary field '" + parsedField.name() + "'");
                }
                seen.add(parsedField.name());
                if (parsedField.getSources().size() >= 2) {
                    return DataType.STRING;
                }
                String source = this.getSingleSource(parsedField);
                if (source.equals("documentid")) {
                    return DataType.STRING;
                }
                if (this.isPositionAttribute(this.schema, source)) {
                    return DataType.LONG;
                }
                ImmutableSDField field = this.schema.getField(source);
                if (field != null) {
                    return field.getDataType();
                }
                if (this.schema.temporaryImportedFields().isPresent() && this.schema.temporaryImportedFields().get().hasField(source)) {
                    return null;
                }
                if (source.equals(parsedField.name()) || !this.summaryFields.containsKey(source)) {
                    throw new IllegalArgumentException("For schema '" + this.schema.getName() + "', document-summary '" + docsum.name() + "', summary field '" + parsedField.name() + "': there is no valid source '" + source + "'.");
                }
                parsedField = this.summaryFields.get(source);
            }
        }
    }
}

