/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.parser.ParsedRankFunction;
import com.yahoo.schema.parser.ParsedRankProfile;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import java.util.List;
import java.util.Map;

public class ConvertParsedRanking {
    private final RankProfileRegistry rankProfileRegistry;

    ConvertParsedRanking() {
        this(new RankProfileRegistry());
    }

    public ConvertParsedRanking(RankProfileRegistry rankProfileRegistry) {
        this.rankProfileRegistry = rankProfileRegistry;
    }

    private RankProfile makeRankProfile(Schema schema, String name) {
        if (name.equals("default")) {
            return this.rankProfileRegistry.get(schema, "default");
        }
        return new RankProfile(name, schema, this.rankProfileRegistry);
    }

    void convertRankProfile(Schema schema, ParsedRankProfile parsed) {
        RankProfile profile = this.makeRankProfile(schema, parsed.name());
        for (String string : parsed.getInherited()) {
            profile.inherit(string);
        }
        parsed.isStrict().ifPresent(profile::setStrict);
        parsed.isUseSignificanceModel().ifPresent(profile::setUseSignificanceModel);
        for (RankProfile.Constant constant : parsed.getConstants().values()) {
            profile.add(constant);
        }
        for (OnnxModel onnxModel : parsed.getOnnxModels()) {
            profile.add(onnxModel);
        }
        for (Map.Entry entry : parsed.getInputs().entrySet()) {
            profile.addInput((Reference)entry.getKey(), (RankProfile.Input)entry.getValue());
        }
        for (ParsedRankFunction parsedRankFunction : parsed.getFunctions()) {
            String name = parsedRankFunction.name();
            List<String> parameters = parsedRankFunction.getParameters();
            String expression = parsedRankFunction.getExpression();
            boolean inline = parsedRankFunction.getInline();
            profile.addFunction(name, parameters, expression, inline);
        }
        parsed.getRankScoreDropLimit().ifPresent(profile::setRankScoreDropLimit);
        parsed.getSecondPhaseRankScoreDropLimit().ifPresent(profile::setSecondPhaseRankScoreDropLimit);
        parsed.getTermwiseLimit().ifPresent(profile::setTermwiseLimit);
        parsed.getPostFilterThreshold().ifPresent(profile::setPostFilterThreshold);
        parsed.getApproximateThreshold().ifPresent(profile::setApproximateThreshold);
        parsed.getTargetHitsMaxAdjustmentFactor().ifPresent(profile::setTargetHitsMaxAdjustmentFactor);
        parsed.getKeepRankCount().ifPresent(profile::setKeepRankCount);
        parsed.getMinHitsPerThread().ifPresent(profile::setMinHitsPerThread);
        parsed.getNumSearchPartitions().ifPresent(profile::setNumSearchPartitions);
        parsed.getNumThreadsPerSearch().ifPresent(profile::setNumThreadsPerSearch);
        parsed.getReRankCount().ifPresent(profile::setRerankCount);
        parsed.getMatchPhase().ifPresent(profile::setMatchPhase);
        parsed.getDiversity().ifPresent(profile::setDiversity);
        parsed.getFirstPhaseExpression().ifPresent(profile::setFirstPhaseRanking);
        parsed.getSecondPhaseExpression().ifPresent(profile::setSecondPhaseRanking);
        parsed.getGlobalPhaseExpression().ifPresent(profile::setGlobalPhaseRanking);
        parsed.getGlobalPhaseRerankCount().ifPresent(profile::setGlobalPhaseRerankCount);
        for (FeatureList featureList : parsed.getMatchFeatures()) {
            profile.addMatchFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getRankFeatures()) {
            profile.addRankFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getSummaryFeatures()) {
            profile.addSummaryFeatures(featureList);
        }
        parsed.getInheritedMatchFeatures().ifPresent(profile::setInheritedMatchFeatures);
        parsed.getInheritedSummaryFeatures().ifPresent(profile::setInheritedSummaryFeatures);
        if (parsed.getIgnoreDefaultRankFeatures()) {
            profile.setIgnoreDefaultRankFeatures(true);
        }
        for (RankProfile.MutateOperation mutateOperation : parsed.getMutateOperations()) {
            profile.addMutateOperation(mutateOperation);
        }
        parsed.getFieldsWithRankFilter().forEach((fieldName, isFilter) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.PREFERBITVECTOR, isFilter));
        parsed.getFieldsWithRankWeight().forEach((fieldName, weight) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.WEIGHT, weight));
        parsed.getFieldsWithRankType().forEach((fieldName, rankType) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(rankType)));
        parsed.getRankProperties().forEach((key, values) -> {
            for (String value : values) {
                profile.addRankProperty((String)key, value);
            }
        });
        this.rankProfileRegistry.add(profile);
    }
}

