/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.significance.config.SignificanceConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.Model;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class SignificanceModelRegistry
extends SimpleComponent
implements SignificanceConfig.Producer {
    private static final String CLASS = "com.yahoo.language.significance.impl.DefaultSignificanceModelRegistry";
    private static final String BUNDLE = null;
    private final List<SignificanceModelConfig> configList = new ArrayList<SignificanceModelConfig>();

    public SignificanceModelRegistry(DeployState deployState, Element spec) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)CLASS, (String)CLASS, (String)BUNDLE)));
        if (spec != null) {
            for (Element modelElement : XML.getChildren((Element)spec, (String)"model")) {
                this.addConfig(Model.fromXml(deployState, modelElement, Set.of("significance-model")).modelReference());
            }
        }
    }

    public void addConfig(ModelReference path) {
        this.configList.add(new SignificanceModelConfig(path));
    }

    public void getConfig(SignificanceConfig.Builder builder) {
        builder.model(this.configList.stream().map(config -> new SignificanceConfig.Model.Builder().path(config.path)).toList());
    }

    static class SignificanceModelConfig {
        private final ModelReference path;

        public SignificanceModelConfig(ModelReference path) {
            this.path = path;
        }
    }
}

