/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class ResourcesReductionValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (ClusterSpec.Id clusterId : context.previousModel().allClusters()) {
            if (!context.model().allClusters().contains(clusterId)) continue;
            this.validate(clusterId, context);
        }
    }

    private void validate(ClusterSpec.Id clusterId, Validation.ChangeContext context) {
        ClusterResources current = this.clusterResources(clusterId, context.previousModel());
        ClusterResources next = this.clusterResources(clusterId, context.model());
        if (current == null || next == null) {
            return;
        }
        if (current.nodeResources().isUnspecified() || next.nodeResources().isUnspecified()) {
            int currentNodes = current.nodes();
            int nextNodes = next.nodes();
            if ((double)nextNodes < 0.5 * (double)currentNodes && nextNodes != currentNodes - 1) {
                context.invalid(ValidationId.resourcesReduction, "Size reduction in '" + clusterId.value() + "' is too large: To guard against mistakes, the new max nodes must be at least 50% of the current nodes. Current nodes: " + currentNodes + ", new nodes: " + nextNodes);
            }
        } else {
            NodeResources currentResources = current.totalResources();
            NodeResources nextResources = next.totalResources();
            if (nextResources.vcpu() < 0.5 * currentResources.vcpu() || nextResources.memoryGb() < 0.5 * currentResources.memoryGb() || nextResources.diskGb() < 0.5 * currentResources.diskGb()) {
                context.invalid(ValidationId.resourcesReduction, "Resource reduction in '" + clusterId.value() + "' is too large: To guard against mistakes, the new max resources must be at least 50% of the current max resources in all dimensions. Current: " + currentResources.withBandwidthGbps(0.0) + ", new: " + nextResources.withBandwidthGbps(0.0));
            }
        }
    }

    private ClusterResources clusterResources(ClusterSpec.Id id, VespaModel model) {
        ContentSearchCluster searchCluster;
        if (!model.provisioned().capacities().containsKey(id)) {
            return null;
        }
        ClusterResources resources = ((Capacity)model.provisioned().capacities().get(id)).maxResources();
        if (!resources.nodeResources().isUnspecified()) {
            return resources;
        }
        ApplicationContainerCluster containerCluster = model.getContainerClusters().get(id.value());
        if (containerCluster != null && !containerCluster.getContainers().isEmpty()) {
            return resources.with(((ApplicationContainer)containerCluster.getContainers().get(0)).getHostResource().advertisedResources());
        }
        ContentCluster contentCluster = model.getContentClusters().get(id.value());
        if (contentCluster != null && !(searchCluster = contentCluster.getSearch()).getSearchNodes().isEmpty()) {
            return resources.with(searchCluster.getSearchNodes().get(0).getHostResource().advertisedResources());
        }
        return resources;
    }
}

