/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

public class DispatchTuning {
    public static final DispatchTuning empty = new Builder().build();
    private final Integer maxHitsPerPartition;
    private DispatchPolicy dispatchPolicy;
    private final Double minActiveDocsCoverage;
    private final Double topkProbability;

    public Double getTopkProbability() {
        return this.topkProbability;
    }

    private DispatchTuning(Builder builder) {
        this.maxHitsPerPartition = builder.maxHitsPerPartition;
        this.dispatchPolicy = builder.dispatchPolicy;
        this.minActiveDocsCoverage = builder.minActiveDocsCoverage;
        this.topkProbability = builder.topKProbability;
    }

    public Integer getMaxHitsPerPartition() {
        return this.maxHitsPerPartition;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public Double getMinActiveDocsCoverage() {
        return this.minActiveDocsCoverage;
    }

    public static class Builder {
        private Integer maxHitsPerPartition;
        private DispatchPolicy dispatchPolicy;
        private Double minActiveDocsCoverage;
        private Double topKProbability;

        public DispatchTuning build() {
            return new DispatchTuning(this);
        }

        public Builder setMaxHitsPerPartition(Integer maxHitsPerPartition) {
            this.maxHitsPerPartition = maxHitsPerPartition;
            return this;
        }

        public Builder setTopKProbability(Double topKProbability) {
            this.topKProbability = topKProbability;
            return this;
        }

        public Builder setDispatchPolicy(String policy) {
            if (policy != null) {
                this.dispatchPolicy = this.toDispatchPolicy(policy);
            }
            return this;
        }

        private DispatchPolicy toDispatchPolicy(String policy) {
            switch (policy.toLowerCase()) {
                case "adaptive": 
                case "random": {
                    return DispatchPolicy.ADAPTIVE;
                }
                case "round-robin": {
                    return DispatchPolicy.ROUNDROBIN;
                }
            }
            throw new IllegalArgumentException("Unknown dispatch policy '" + policy + "'");
        }

        public Builder setMinActiveDocsCoverage(Double minCoverage) {
            this.minActiveDocsCoverage = minCoverage;
            return this;
        }
    }

    public static enum DispatchPolicy {
        ROUNDROBIN,
        ADAPTIVE;

    }
}

