/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.search.query.profile.OverridableQueryProfile;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVariants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeclaredQueryProfileVariants {
    private final Map<String, VariantQueryProfile> variantQueryProfiles = new LinkedHashMap<String, VariantQueryProfile>();

    public DeclaredQueryProfileVariants(QueryProfile profile) {
        for (Map.Entry fieldValueEntry : profile.getVariants().getFieldValues().entrySet()) {
            for (QueryProfileVariants.FieldValue fieldValue : ((QueryProfileVariants.FieldValues)fieldValueEntry.getValue()).asList()) {
                this.addVariant((String)fieldValueEntry.getKey(), fieldValue.getValue(), profile.getVariants().getVariant(fieldValue.getDimensionValues(), false).isOverridable((String)fieldValueEntry.getKey()), fieldValue.getDimensionValues().getValues());
            }
        }
        for (QueryProfileVariants.FieldValue fieldValue : profile.getVariants().getInherited().asList()) {
            for (QueryProfile inherited : (List)fieldValue.getValue()) {
                this.addVariantInherited(inherited, fieldValue.getDimensionValues().getValues());
            }
        }
        this.dereferenceCompoundedVariants(profile, "");
    }

    private void addVariant(String name, Object value, Boolean overridable, String[] dimensionValues) {
        String dimensionString = this.toCanonicalString(dimensionValues);
        VariantQueryProfile variant = this.variantQueryProfiles.get(dimensionString);
        if (variant == null) {
            variant = new VariantQueryProfile(dimensionValues);
            this.variantQueryProfiles.put(dimensionString, variant);
        }
        variant.getValues().put(name, value);
        if (overridable != null) {
            variant.getOverriable().put(name, overridable);
        }
    }

    private void addVariantInherited(QueryProfile inherited, String[] dimensionValues) {
        String dimensionString = this.toCanonicalString(dimensionValues);
        VariantQueryProfile variant = this.variantQueryProfiles.get(dimensionString);
        if (variant == null) {
            variant = new VariantQueryProfile(dimensionValues);
            this.variantQueryProfiles.put(dimensionString, variant);
        }
        variant.inherit(inherited);
    }

    private void dereferenceCompoundedVariants(QueryProfile profile, String prefix) {
        for (Map.Entry entry : profile.declaredContent().entrySet()) {
            QueryProfile subProfile;
            if (!(entry.getValue() instanceof QueryProfile) || (subProfile = (QueryProfile)entry.getValue()).isExplicit() && !(subProfile instanceof OverridableQueryProfile)) continue;
            String entryPrefix = prefix + (String)entry.getKey() + ".";
            this.dereferenceCompoundedVariants(subProfile.getVariants(), entryPrefix);
            this.dereferenceCompoundedVariants(subProfile, entryPrefix);
        }
        if (profile.getVariants() == null) {
            return;
        }
        for (Map.Entry fieldValueEntry : profile.getVariants().getFieldValues().entrySet()) {
            for (QueryProfileVariants.FieldValue fieldValue : ((QueryProfileVariants.FieldValues)fieldValueEntry.getValue()).asList()) {
                QueryProfile subProfile;
                if (!(fieldValue.getValue() instanceof QueryProfile) || (subProfile = (QueryProfile)fieldValue.getValue()).isExplicit() && !(subProfile instanceof OverridableQueryProfile)) continue;
                String entryPrefix = prefix + (String)fieldValueEntry.getKey() + ".";
                this.dereferenceCompoundedVariants(subProfile.getVariants(), entryPrefix);
                this.dereferenceCompoundedVariants(subProfile, entryPrefix);
            }
        }
    }

    private void dereferenceCompoundedVariants(QueryProfileVariants profileVariants, String prefix) {
        if (profileVariants == null) {
            return;
        }
        for (Map.Entry fieldVariant : profileVariants.getFieldValues().entrySet()) {
            for (QueryProfileVariants.FieldValue variantValue : ((QueryProfileVariants.FieldValues)fieldVariant.getValue()).asList()) {
                this.addVariant(prefix + (String)fieldVariant.getKey(), variantValue.getValue(), null, variantValue.getDimensionValues().getValues());
            }
        }
    }

    public String toCanonicalString(String[] dimensionValues) {
        StringBuilder b = new StringBuilder();
        for (String dimensionValue : dimensionValues) {
            if (dimensionValue != null) {
                b.append(dimensionValue);
            } else {
                b.append("*");
            }
            b.append(",");
        }
        b.deleteCharAt(b.length() - 1);
        return b.toString();
    }

    public Map<String, VariantQueryProfile> getVariantQueryProfiles() {
        return this.variantQueryProfiles;
    }

    public static class VariantQueryProfile {
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();
        private final Map<String, Boolean> overridable = new HashMap<String, Boolean>();
        private final List<QueryProfile> inherited = new ArrayList<QueryProfile>();
        private final String[] dimensionValues;

        public VariantQueryProfile(String[] dimensionValues) {
            this.dimensionValues = dimensionValues;
        }

        public String[] getDimensionValues() {
            return this.dimensionValues;
        }

        public void inherit(QueryProfile inheritedProfile) {
            this.inherited.add(inheritedProfile);
        }

        public List<QueryProfile> inherited() {
            return this.inherited;
        }

        public Map<String, Object> getValues() {
            return this.values;
        }

        public Map<String, Boolean> getOverriable() {
            return this.overridable;
        }
    }
}

