/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import java.util.Optional;

public class CloudWatch {
    private final String region;
    private final String namespace;
    private final MetricsConsumer consumer;
    private HostedAuth hostedAuth;
    private SharedCredentials sharedCredentials;

    public CloudWatch(String region, String namespace, MetricsConsumer consumer) {
        this.region = region;
        this.namespace = namespace;
        this.consumer = consumer;
    }

    public String region() {
        return this.region;
    }

    public String namespace() {
        return this.namespace;
    }

    public String consumer() {
        return this.consumer.id();
    }

    public Optional<HostedAuth> hostedAuth() {
        return Optional.ofNullable(this.hostedAuth);
    }

    public Optional<SharedCredentials> sharedCredentials() {
        return Optional.ofNullable(this.sharedCredentials);
    }

    public void setHostedAuth(String accessKeyName, String secretKeyName) {
        this.hostedAuth = new HostedAuth(accessKeyName, secretKeyName);
    }

    public void setSharedCredentials(String file, Optional<String> profile) {
        this.sharedCredentials = new SharedCredentials(file, profile);
    }

    public static class HostedAuth {
        public final String accessKeyName;
        public final String secretKeyName;

        HostedAuth(String accessKeyName, String secretKeyName) {
            this.accessKeyName = accessKeyName;
            this.secretKeyName = secretKeyName;
        }
    }

    public static class SharedCredentials {
        public final String file;
        public final Optional<String> profile;

        SharedCredentials(String file, Optional<String> profile) {
            this.file = file;
            this.profile = profile;
        }
    }
}

