/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.derived.FieldResultTransform;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SummaryMap
extends Derived
implements SummarymapConfig.Producer {
    private final Map<String, FieldResultTransform> resultTransforms = new LinkedHashMap<String, FieldResultTransform>();

    SummaryMap(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        for (DocumentSummary documentSummary : schema.getSummaries().values()) {
            this.derive(documentSummary);
        }
        this.addSummaryTransformForDocumentId();
        super.derive(schema);
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
    }

    private void addSummaryTransformForDocumentId() {
        if (!this.resultTransforms.containsKey("documentid")) {
            this.resultTransforms.put("documentid", new FieldResultTransform("documentid", SummaryTransform.DOCUMENT_ID, ""));
        }
    }

    private void derive(DocumentSummary documentSummary) {
        for (SummaryField summaryField : documentSummary.getSummaryFields().values()) {
            if (summaryField.getTransform() == SummaryTransform.NONE) continue;
            if (summaryField.getTransform() == SummaryTransform.ATTRIBUTE || summaryField.getTransform() == SummaryTransform.ATTRIBUTECOMBINER && summaryField.hasExplicitSingleSource() || summaryField.getTransform() == SummaryTransform.COPY || summaryField.getTransform() == SummaryTransform.DISTANCE || summaryField.getTransform() == SummaryTransform.GEOPOS || summaryField.getTransform() == SummaryTransform.POSITIONS || summaryField.getTransform() == SummaryTransform.MATCHED_ELEMENTS_FILTER || summaryField.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER) {
                this.resultTransforms.put(summaryField.getName(), new FieldResultTransform(summaryField.getName(), summaryField.getTransform(), summaryField.getSingleSource()));
                continue;
            }
            boolean useFieldNameAsArgument = summaryField.getTransform().isDynamic();
            this.resultTransforms.put(summaryField.getName(), new FieldResultTransform(summaryField.getName(), summaryField.getTransform(), useFieldNameAsArgument ? summaryField.getName() : ""));
        }
    }

    public Map<String, FieldResultTransform> resultTransforms() {
        return Collections.unmodifiableMap(this.resultTransforms);
    }

    @Override
    protected String getDerivedName() {
        return "summarymap";
    }

    private String getCommand(SummaryTransform transform) {
        if (transform == SummaryTransform.DISTANCE) {
            return "absdist";
        }
        if (transform.isDynamic()) {
            return "dynamicteaser";
        }
        return transform.getName();
    }

    public static boolean isDynamicCommand(String commandName) {
        return commandName.equals("dynamicteaser") || commandName.equals(SummaryTransform.MATCHED_ELEMENTS_FILTER.getName()) || commandName.equals(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER.getName());
    }

    public void getConfig(SummarymapConfig.Builder builder) {
        builder.defaultoutputclass(-1);
        for (FieldResultTransform frt : this.resultTransforms.values()) {
            SummarymapConfig.Override.Builder oB = new SummarymapConfig.Override.Builder().field(frt.getFieldName()).command(this.getCommand(frt.getTransform())).arguments(frt.getArgument());
            builder.override(oB);
        }
    }
}

