/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedType;
import java.util.ArrayList;
import java.util.List;

class ParsedSummaryField
extends ParsedBlock {
    private ParsedType type;
    private boolean isDyn = false;
    private boolean isMEO = false;
    private boolean isFull = false;
    private boolean isBold = false;
    private boolean isTokens = false;
    private boolean hasExplicitType = false;
    private final List<String> sources = new ArrayList<String>();
    private final List<String> destinations = new ArrayList<String>();

    ParsedSummaryField(String name) {
        this(name, (ParsedType)null);
    }

    ParsedSummaryField(String name, ParsedType type) {
        super(name, "summary field");
        this.type = type;
    }

    ParsedType getType() {
        return this.type;
    }

    List<String> getDestinations() {
        return List.copyOf(this.destinations);
    }

    List<String> getSources() {
        return List.copyOf(this.sources);
    }

    boolean getBolded() {
        return this.isBold;
    }

    boolean getDynamic() {
        return this.isDyn;
    }

    boolean getFull() {
        return this.isFull;
    }

    boolean getMatchedElementsOnly() {
        return this.isMEO;
    }

    boolean getTokens() {
        return this.isTokens;
    }

    boolean getHasExplicitType() {
        return this.hasExplicitType;
    }

    void addDestination(String dst) {
        this.destinations.add(dst);
    }

    void addSource(String src) {
        this.sources.add(src);
    }

    void setBold(boolean value) {
        this.isBold = value;
    }

    void setDynamic() {
        this.isDyn = true;
    }

    void setFull() {
        this.isFull = true;
    }

    void setMatchedElementsOnly() {
        this.isMEO = true;
    }

    void setTokens() {
        this.isTokens = true;
    }

    void setHasExplicitType() {
        this.hasExplicitType = true;
    }

    void setType(ParsedType value) {
        this.verifyThat(this.type == null, "Cannot change type from ", this.type, "to", value);
        this.type = value;
    }
}

