/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import ai.vespa.llm.clients.LocalLLM;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ContainerCluster;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RestartOnDeployForLocalLLMValidator
implements ChangeValidator {
    public static final String LOCAL_LLM_COMPONENT = LocalLLM.class.getName();
    private static final Logger log = Logger.getLogger(RestartOnDeployForLocalLLMValidator.class.getName());

    @Override
    public void validate(Validation.ChangeContext context) {
        Set<ClusterSpec.Id> previousClustersWithLocalLLM = this.findClustersWithLocalLLMs(context.previousModel());
        Set<ClusterSpec.Id> nextClustersWithLocalLLM = this.findClustersWithLocalLLMs(context.model());
        for (ClusterSpec.Id clusterId : this.intersect(previousClustersWithLocalLLM, nextClustersWithLocalLLM)) {
            String message = "Need to restart services in %s due to use of local LLM".formatted(clusterId);
            context.require(new VespaRestartAction(clusterId, message));
            log.log(Level.INFO, message);
        }
    }

    private Set<ClusterSpec.Id> findClustersWithLocalLLMs(VespaModel model) {
        return model.getContainerClusters().values().stream().filter(cluster -> cluster.getAllComponents().stream().anyMatch(component -> component.getClassId().getName().equals(LOCAL_LLM_COMPONENT))).map(ContainerCluster::id).collect(Collectors.toUnmodifiableSet());
    }

    private Set<ClusterSpec.Id> intersect(Set<ClusterSpec.Id> a, Set<ClusterSpec.Id> b) {
        HashSet<ClusterSpec.Id> result = new HashSet<ClusterSpec.Id>(a);
        result.retainAll(b);
        return result;
    }
}

