/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.component.chain.Chains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomChainsBuilder<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>, CHAINS extends Chains<CHAIN>>
extends VespaDomBuilder.DomConfigProducerBuilderBase<CHAINS> {
    private final Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes;

    protected DomChainsBuilder(Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes) {
        this.allowedComponentTypes = new ArrayList<ComponentsBuilder.ComponentType<COMPONENT>>(allowedComponentTypes);
    }

    protected abstract CHAINS newChainsInstance(TreeConfigProducer<AnyConfigProducer> var1);

    @Override
    protected final CHAINS doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element chainsElement) {
        CHAINS chains = this.newChainsInstance(parent);
        List<Element> allChainElements = this.allChainElements(deployState, chainsElement);
        if (!allChainElements.isEmpty()) {
            ComponentsBuilder<COMPONENT> outerComponentsBuilder = this.readOuterComponents(deployState, (TreeConfigProducer<AnyConfigProducer>)chains, allChainElements);
            ChainsBuilder<COMPONENT, CHAIN> chainsBuilder = this.readChains(deployState, (TreeConfigProducer<AnyConfigProducer>)chains, allChainElements, outerComponentsBuilder.getComponentTypeByComponentName());
            this.addOuterComponents(chains, outerComponentsBuilder);
            this.addChains(chains, chainsBuilder);
        }
        return chains;
    }

    private List<Element> allChainElements(DeployState deployState, Element chainsElement) {
        ArrayList<Element> chainsElements = new ArrayList<Element>();
        chainsElements.add(chainsElement);
        return chainsElements;
    }

    private ComponentsBuilder<COMPONENT> readOuterComponents(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, List<Element> chainsElems) {
        return new ComponentsBuilder(deployState, ancestor, this.allowedComponentTypes, chainsElems, null);
    }

    protected abstract ChainsBuilder<COMPONENT, CHAIN> readChains(DeployState var1, TreeConfigProducer<AnyConfigProducer> var2, List<Element> var3, Map<String, ComponentsBuilder.ComponentType<?>> var4);

    private void addOuterComponents(CHAINS chains, ComponentsBuilder<COMPONENT> outerComponentsBuilder) {
        assert (outerComponentsBuilder.getOuterComponentReferences().isEmpty());
        for (ChainedComponent outerComponent : outerComponentsBuilder.getComponentDefinitions()) {
            ((Chains)chains).add(outerComponent);
        }
    }

    private void addChains(CHAINS chains, ChainsBuilder<COMPONENT, CHAIN> chainsBuilder) {
        for (Chain chain : chainsBuilder.getChains()) {
            ((Chains)chains).add((Chain)chain);
        }
    }
}

