/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;

public class UrlConfigValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHostedTenantApplication(context.model().getAdmin().getApplicationType())) {
            return;
        }
        context.model().getContainerClusters().forEach((__, cluster) -> {
            boolean isExclusive = UrlConfigValidator.hasExclusiveNodes(context.model(), cluster);
            UrlConfigValidator.validateS3UlsInConfig(context, cluster, isExclusive);
        });
    }

    private static boolean hasExclusiveNodes(VespaModel model, ApplicationContainerCluster cluster) {
        return model.hostSystem().getHosts().stream().flatMap(hostResource -> hostResource.spec().membership().stream()).filter(membership -> membership.cluster().id().equals((Object)cluster.id())).anyMatch(membership -> membership.cluster().isExclusive());
    }

    private static void validateS3UlsInConfig(Validation.Context context, ApplicationContainerCluster cluster, boolean isExclusive) {
        if (UrlConfigValidator.hasS3UrlInConfig(cluster)) {
            String message = "Found s3:// urls in config for container cluster " + cluster.getName();
            if (!context.deployState().zone().system().isPublic()) {
                context.illegal(message + ". This is only supported in public systems");
            } else if (!isExclusive) {
                context.illegal(message + ". Nodes in the cluster need to be 'exclusive', see https://cloud.vespa.ai/en/reference/services#nodes");
            }
        }
    }

    private static boolean hasS3UrlInConfig(ApplicationContainerCluster cluster) {
        return cluster.userConfiguredUrls().all().stream().anyMatch(url -> url.startsWith("s3://"));
    }
}

