/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.otel;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.defaults.Defaults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class OpenTelemetryConfigGenerator {
    private final boolean useTls;
    private final String ca_file;
    private final String cert_file;
    private final String key_file;
    private List<ApplicationConfigProducerRoot.StatePortInfo> statePorts = new ArrayList<ApplicationConfigProducerRoot.StatePortInfo>();

    OpenTelemetryConfigGenerator(Zone zone) {
        boolean isCd = true;
        boolean isPublic = true;
        if (zone != null) {
            isCd = zone.system().isCd();
            isPublic = zone.system().isPublic();
            this.useTls = true;
        } else {
            this.useTls = false;
        }
        if (isCd) {
            if (isPublic) {
                this.ca_file = "/opt/vespa/var/vespa/trust-store.pem";
                this.cert_file = "/var/lib/sia/certs/vespa.external.cd.tenant.cert.pem";
                this.key_file = "/var/lib/sia/keys/vespa.external.cd.tenant.key.pem";
            } else {
                this.ca_file = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
                this.cert_file = "/var/lib/sia/certs/vespa.vespa.cd.tenant.cert.pem";
                this.key_file = "/var/lib/sia/keys/vespa.vespa.cd.tenant.key.pem";
            }
        } else if (isPublic) {
            this.ca_file = "/opt/vespa/var/vespa/trust-store.pem";
            this.cert_file = "/var/lib/sia/certs/vespa.external.tenant.cert.pem";
            this.key_file = "/var/lib/sia/keys/vespa.external.tenant.key.pem";
        } else {
            this.ca_file = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
            this.cert_file = "/var/lib/sia/certs/vespa.vespa.tenant.cert.pem";
            this.key_file = "/var/lib/sia/keys/vespa.vespa.tenant.key.pem";
        }
    }

    String receiverName(int index) {
        return "prometheus_simple/s" + index;
    }

    private void addReceivers(JsonGenerator g) throws IOException {
        g.writeFieldName("receivers");
        g.writeStartObject();
        int counter = 0;
        for (ApplicationConfigProducerRoot.StatePortInfo statePort : this.statePorts) {
            this.addReceiver(g, ++counter, statePort);
        }
        g.writeEndObject();
    }

    private void addReceiver(JsonGenerator g, int index, ApplicationConfigProducerRoot.StatePortInfo statePort) throws IOException {
        g.writeFieldName(this.receiverName(index));
        g.writeStartObject();
        g.writeStringField("collection_interval", "60s");
        g.writeStringField("endpoint", statePort.hostName() + ":" + statePort.portNumber());
        this.addUrlInfo(g);
        if (this.useTls) {
            this.addTls(g);
        }
        g.writeFieldName("labels");
        g.writeStartObject();
        g.writeStringField("service_type", statePort.serviceType());
        g.writeEndObject();
        g.writeEndObject();
    }

    private void addTls(JsonGenerator g) throws IOException {
        g.writeFieldName("tls");
        g.writeStartObject();
        g.writeStringField("ca_file", this.ca_file);
        g.writeStringField("cert_file", this.cert_file);
        g.writeBooleanField("insecure_skip_verify", true);
        g.writeStringField("key_file", this.key_file);
        g.writeEndObject();
    }

    private void addUrlInfo(JsonGenerator g) throws IOException {
        g.writeStringField("metrics_path", "/state/v1/metrics");
        g.writeFieldName("params");
        g.writeStartObject();
        g.writeStringField("format", "prometheus");
        g.writeEndObject();
    }

    private void addExporters(JsonGenerator g) throws IOException {
        g.writeFieldName("exporters");
        g.writeStartObject();
        this.addFileExporter(g);
        g.writeEndObject();
    }

    private void addFileExporter(JsonGenerator g) throws IOException {
        g.writeFieldName("file");
        g.writeStartObject();
        g.writeStringField("path", Defaults.getDefaults().underVespaHome("logs/vespa/otel-test.json"));
        g.writeFieldName("rotation");
        g.writeStartObject();
        g.writeNumberField("max_megabytes", 10);
        g.writeNumberField("max_days", 3);
        g.writeNumberField("max_backups", 1);
        g.writeEndObject();
        g.writeEndObject();
    }

    private void addServiceBlock(JsonGenerator g) throws IOException {
        g.writeFieldName("service");
        g.writeStartObject();
        g.writeFieldName("telemetry");
        g.writeStartObject();
        g.writeFieldName("logs");
        g.writeStartObject();
        g.writeStringField("level", "debug");
        g.writeEndObject();
        g.writeEndObject();
        g.writeFieldName("pipelines");
        g.writeStartObject();
        this.addMetricsPipelines(g);
        g.writeEndObject();
        g.writeEndObject();
    }

    private void addMetricsPipelines(JsonGenerator g) throws IOException {
        g.writeFieldName("metrics");
        g.writeStartObject();
        g.writeFieldName("receivers");
        g.writeStartArray();
        int counter = 0;
        for (ApplicationConfigProducerRoot.StatePortInfo statePort : this.statePorts) {
            g.writeString(this.receiverName(++counter));
        }
        g.writeEndArray();
        g.writeFieldName("processors");
        g.writeStartArray();
        g.writeEndArray();
        g.writeFieldName("exporters");
        g.writeStartArray();
        g.writeString("file");
        g.writeEndArray();
        g.writeEndObject();
    }

    public String generate() {
        if (this.statePorts.isEmpty()) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JsonGenerator g = new JsonFactory().createGenerator((OutputStream)out, JsonEncoding.UTF8);
            g.writeStartObject();
            this.addReceivers(g);
            this.addExporters(g);
            this.addServiceBlock(g);
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            System.err.println("unexpected error: " + e);
            return "";
        }
        return out.toString(StandardCharsets.UTF_8);
    }

    void addStatePorts(List<ApplicationConfigProducerRoot.StatePortInfo> portList) {
        this.statePorts = portList;
    }

    List<String> referencedPaths() {
        return List.of(this.ca_file, this.cert_file, this.key_file);
    }
}

