/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing.multifieldresolver;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.multifieldresolver.MultiFieldResolver;
import java.util.List;
import java.util.logging.Level;

public class IndexCommandResolver
extends MultiFieldResolver {
    private static final List<String> ignoredCommands = List.of("complete-boost", "literal-boost", "highlight");
    private static final List<String> harmonizedCommands = List.of("stemming", "normalizing");

    public IndexCommandResolver(String indexName, List<SDField> fields, Schema schema, DeployLogger logger) {
        super(indexName, fields, schema, logger);
    }

    @Override
    public void resolve() {
        for (SDField field : this.fields) {
            for (String command : field.getQueryCommands()) {
                if (ignoredCommands.contains(command)) continue;
                this.checkCommand(command);
            }
        }
    }

    private void checkCommand(String command) {
        for (SDField field : this.fields) {
            if (field.hasQueryCommand(command)) continue;
            if (harmonizedCommands.contains(command)) {
                this.deployLogger.logApplicationPackage(Level.WARNING, command + " must be added to all fields going to the same index (" + this.indexName + "), adding to field " + field.getName());
                field.addQueryCommand(command);
                continue;
            }
            this.deployLogger.logApplicationPackage(Level.WARNING, "All fields going to the same index should have the same query-commands. Field '" + field.getName() + "' doesn't contain command '" + command + "'");
        }
    }
}

