/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.vespa.model.container.component.BindingPattern;

public class SystemBindingPattern
extends BindingPattern {
    private SystemBindingPattern(String scheme, String host, String port, String path) {
        super(scheme, host, port, path);
    }

    private SystemBindingPattern(String binding) {
        super(binding);
    }

    public static SystemBindingPattern fromHttpPath(String path) {
        return new SystemBindingPattern("http", "*", null, path);
    }

    public static SystemBindingPattern fromPattern(String binding) {
        return new SystemBindingPattern(binding);
    }

    public static SystemBindingPattern fromHttpPortAndPath(String port, String path) {
        return new SystemBindingPattern("http", "*", port, path);
    }

    public static SystemBindingPattern fromHttpPortAndPath(int port, String path) {
        return new SystemBindingPattern("http", "*", Integer.toString(port), path);
    }

    public SystemBindingPattern withPort(int port) {
        return new SystemBindingPattern(this.scheme(), this.host(), Integer.toString(port), this.path());
    }

    public String toString() {
        return "SystemBindingPattern{scheme='" + this.scheme() + "', host='" + this.host() + "', port='" + (String)this.port().orElse(null) + "', path='" + this.path() + "'}";
    }
}

