/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.CuratorConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.concurrent.classlock.ClassLocking;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.container.di.config.PlatformBundlesConfig;
import com.yahoo.container.handler.ClustersStatus;
import com.yahoo.container.handler.LogHandler;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.usability.BindingsOverviewHandler;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.VoidRequestLog;
import com.yahoo.metrics.simple.MetricManager;
import com.yahoo.metrics.simple.jdisc.JdiscMetricsFactory;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.DefaultThreadpoolProvider;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.SecretStore;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.Client;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.search.SearchCluster;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.TreeSet;

public abstract class ContainerCluster<CONTAINER extends Container>
extends TreeConfigProducer<AnyConfigProducer>
implements ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
DocumentmanagerConfig.Producer,
ContainerDocumentConfig.Producer,
HealthMonitorConfig.Producer,
ApplicationMetadataConfig.Producer,
PlatformBundlesConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemamappingConfig.Producer,
QrSearchersConfig.Producer,
QrStartConfig.Producer,
QueryProfilesConfig.Producer,
PageTemplatesConfig.Producer,
SemanticRulesConfig.Producer,
DocprocConfig.Producer,
ClusterInfoConfig.Producer,
ConfigserverConfig.Producer,
CuratorConfig.Producer,
SchemaInfoConfig.Producer {
    public static final String RESERVED_URI_PREFIX = "/reserved-for-internal-use";
    public static final String APPLICATION_STATUS_HANDLER_CLASS = "com.yahoo.container.handler.observability.ApplicationStatusHandler";
    public static final String BINDINGS_OVERVIEW_HANDLER_CLASS = BindingsOverviewHandler.class.getName();
    public static final String LOG_HANDLER_CLASS = LogHandler.class.getName();
    public static final String G1GC = "-XX:+UseG1GC -XX:MaxTenuringThreshold=15";
    public static final String PARALLEL_GC = "-XX:+UseParallelGC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1";
    public static final String STATE_HANDLER_CLASS = "com.yahoo.container.jdisc.state.StateHandler";
    public static final BindingPattern STATE_HANDLER_BINDING_1 = SystemBindingPattern.fromHttpPath("/state/v1");
    public static final BindingPattern STATE_HANDLER_BINDING_2 = SystemBindingPattern.fromHttpPath("/state/v1/*");
    public static final String ROOT_HANDLER_PATH = "/";
    public static final BindingPattern ROOT_HANDLER_BINDING = SystemBindingPattern.fromHttpPath("/");
    public static final BindingPattern VIP_HANDLER_BINDING = SystemBindingPattern.fromHttpPath("/status.html");
    private final String name;
    protected List<CONTAINER> containers = new ArrayList<CONTAINER>();
    private Http http;
    private ProcessingChains processingChains;
    private ContainerSearch containerSearch;
    private ContainerDocproc containerDocproc;
    private ContainerDocumentApi containerDocumentApi;
    private SecretStore secretStore;
    private final ContainerThreadpool defaultHandlerThreadpool;
    private boolean rpcServerEnabled = true;
    private boolean httpServerEnabled = true;
    private final Set<Path> platformBundles = new TreeSet<Path>();
    private final ComponentGroup<Component<?, ?>> componentGroup;
    protected final boolean isHostedVespa;
    private final boolean zooKeeperLocalhostAffinity;
    private final String compressionType;
    private final Map<String, String> concreteDocumentTypes = new LinkedHashMap<String, String>();
    private ApplicationMetaData applicationMetaData = null;
    private Zone zone;
    private String hostClusterId = null;
    private String jvmGCOptions = null;
    private volatile boolean deferChangesUntilRestart = false;
    private boolean clientsLegacyMode;
    private List<Client> clients = List.of();

    public ContainerCluster(TreeConfigProducer<?> parent, String configSubId, String clusterId, DeployState deployState, boolean zooKeeperLocalhostAffinity) {
        this(parent, configSubId, clusterId, deployState, zooKeeperLocalhostAffinity, 1);
    }

    public ContainerCluster(TreeConfigProducer<?> parent, String configSubId, String clusterId, DeployState deployState, boolean zooKeeperLocalhostAffinity, int defaultPoolNumThreads) {
        super(parent, configSubId);
        this.name = clusterId;
        this.isHostedVespa = ContainerCluster.stateIsHosted(deployState);
        this.zone = deployState != null ? deployState.zone() : Zone.defaultZone();
        this.zooKeeperLocalhostAffinity = zooKeeperLocalhostAffinity;
        this.compressionType = deployState.featureFlags().logFileCompressionAlgorithm("zstd");
        this.componentGroup = new ComponentGroup((TreeConfigProducer<AnyConfigProducer>)this, "component");
        this.addCommonVespaBundles();
        this.addSimpleComponent(VoidRequestLog.class);
        this.addComponent(new DefaultThreadpoolProvider(this, defaultPoolNumThreads));
        this.defaultHandlerThreadpool = new Handler.DefaultHandlerThreadpool(deployState, null);
        this.addComponent(this.defaultHandlerThreadpool);
        this.addSimpleComponent(ClassLocking.class);
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricConsumerProviderProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricUpdater");
        this.addSimpleComponent(ThreadedHttpRequestHandler.Context.class);
        this.addSimpleComponent(MetricManager.class.getName());
        this.addSimpleComponent(JdiscMetricsFactory.class.getName());
        this.addSimpleComponent("com.yahoo.container.jdisc.state.StateMonitor");
        this.addSimpleComponent("com.yahoo.container.jdisc.ContainerThreadFactory");
        this.addSimpleComponent("com.yahoo.container.handler.VipStatus");
        this.addSimpleComponent(ClustersStatus.class.getName());
        this.addSimpleComponent("com.yahoo.container.jdisc.DisabledConnectionLogProvider");
        this.addSimpleComponent(Janitor.class);
    }

    protected abstract boolean messageBusEnabled();

    public ClusterSpec.Id id() {
        return ClusterSpec.Id.from((String)this.getName());
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Zone getZone() {
        return this.zone;
    }

    protected Optional<Admin> getAdmin() {
        AbstractConfigProducerRoot r;
        AnyConfigProducer parent = this.getParent();
        if (parent != null && (r = parent.getRoot()) instanceof VespaModel) {
            VespaModel model = (VespaModel)r;
            return Optional.ofNullable(model.getAdmin());
        }
        return Optional.empty();
    }

    public void addDefaultHandlersWithVip() {
        this.addDefaultHandlersExceptStatus();
        this.addVipHandler();
    }

    public final void addDefaultHandlersExceptStatus() {
        this.addDefaultRootHandler();
        this.addMetricStateHandler();
        this.addApplicationStatusHandler();
    }

    public void addMetricStateHandler() {
        Handler stateHandler = new Handler(new ComponentModel(STATE_HANDLER_CLASS, null, null, null));
        stateHandler.addServerBindings(STATE_HANDLER_BINDING_1, STATE_HANDLER_BINDING_2);
        this.addComponent(stateHandler);
    }

    public void addDefaultRootHandler() {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)BINDINGS_OVERVIEW_HANDLER_CLASS, null, null), null));
        handler.addServerBindings(ROOT_HANDLER_BINDING);
        this.addComponent(handler);
    }

    public void addApplicationStatusHandler() {
        Handler statusHandler = new Handler(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)APPLICATION_STATUS_HANDLER_CLASS, null, null), null));
        statusHandler.addServerBindings(SystemBindingPattern.fromHttpPath("/ApplicationStatus"));
        this.addComponent(statusHandler);
    }

    public void addVipHandler() {
        Handler vipHandler = Handler.fromClassName("com.yahoo.container.handler.VipStatusHandler");
        vipHandler.addServerBindings(VIP_HANDLER_BINDING);
        this.addComponent(vipHandler);
    }

    public final void addComponent(Component<?, ?> component) {
        this.componentGroup.addComponent(component);
        if (component instanceof Handler) {
            Handler handler = (Handler)component;
            this.ensureHandlerHasThreadpool(handler);
        }
    }

    private void ensureHandlerHasThreadpool(Handler handler) {
        if (!handler.hasCustomThreadPool) {
            handler.inject(this.defaultHandlerThreadpool);
        }
    }

    public final void addSimpleComponent(String idSpec, String classSpec, String bundleSpec) {
        this.addComponent(new SimpleComponent(new ComponentModel(idSpec, classSpec, bundleSpec)));
    }

    public Component<?, ?> removeComponent(ComponentId componentId) {
        return (Component)this.componentGroup.removeComponent(componentId);
    }

    public void removeSimpleComponent(Class<?> clazz) {
        this.removeComponent(new SimpleComponent(clazz.getName()).getComponentId());
    }

    public void addSimpleComponent(Class<?> clazz) {
        this.addSimpleComponent(clazz.getName());
    }

    protected void addSimpleComponent(String className) {
        this.addComponent(new SimpleComponent(className));
    }

    public void prepare(DeployState deployState) {
        this.applicationMetaData = deployState.getApplicationPackage().getMetaData();
        this.doPrepare(deployState);
    }

    protected void doPrepare(DeployState deployState) {
        this.wireLogctlSpecs();
    }

    private void wireLogctlSpecs() {
        this.getAdmin().ifPresent(admin -> {
            for (Container c : this.getContainers()) {
                c.setLogctlSpecs(admin.getLogctlSpecs());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public List<CONTAINER> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public void addContainer(CONTAINER container) {
        ((Container)container).setOwner(this);
        ((Container)container).setClusterName(this.name);
        ((AbstractService)container).setProp("clustername", this.name).setProp("index", this.containers.size()).setProp("clustertype", "container");
        this.containers.add(container);
    }

    public void addContainers(Collection<CONTAINER> containers) {
        containers.forEach(this::addContainer);
    }

    public void setProcessingChains(ProcessingChains processingChains, BindingPattern ... serverBindings) {
        if (this.processingChains != null) {
            throw new IllegalStateException("ProcessingChains should only be set once.");
        }
        this.processingChains = processingChains;
        ProcessingHandler<ProcessingChains> processingHandler = new ProcessingHandler<ProcessingChains>(processingChains, BundleInstantiationSpecification.fromStrings((String)"com.yahoo.processing.handler.ProcessingHandler", null, null));
        for (BindingPattern binding : serverBindings) {
            processingHandler.addServerBindings(binding);
        }
        this.addComponent(processingHandler);
    }

    ProcessingChains getProcessingChains() {
        return this.processingChains;
    }

    public SearchChains getSearchChains() {
        if (this.containerSearch == null) {
            throw new IllegalArgumentException("Search components not found in container cluster '" + this.getSubId() + "': Add <search/> to the cluster in services.xml");
        }
        return (SearchChains)this.containerSearch.getChains();
    }

    public ContainerSearch getSearch() {
        return this.containerSearch;
    }

    public void setSearch(ContainerSearch containerSearch) {
        this.containerSearch = containerSearch;
    }

    public void setHttp(Http http) {
        this.http = http;
        this.addChild(http);
    }

    public Http getHttp() {
        return this.http;
    }

    public void setClients(boolean legacyMode, List<Client> clients) {
        this.clientsLegacyMode = legacyMode;
        this.clients = clients;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public boolean clientsLegacyMode() {
        return this.clientsLegacyMode;
    }

    public ContainerDocproc getDocproc() {
        return this.containerDocproc;
    }

    public void setDocproc(ContainerDocproc containerDocproc) {
        this.containerDocproc = containerDocproc;
    }

    public void setDocumentApi(ContainerDocumentApi containerDocumentApi) {
        this.containerDocumentApi = containerDocumentApi;
    }

    public DocprocChains getDocprocChains() {
        if (this.containerDocproc == null) {
            throw new IllegalArgumentException("Document processing components not found in container cluster '" + this.getSubId() + "': Add <document-processing/> to the cluster in services.xml");
        }
        return (DocprocChains)this.containerDocproc.getChains();
    }

    public Collection<Handler> getHandlers() {
        return this.componentGroup.getComponents(Handler.class);
    }

    public void setSecretStore(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public Optional<SecretStore> getSecretStore() {
        return Optional.ofNullable(this.secretStore);
    }

    public Map<ComponentId, Component<?, ?>> getComponentsMap() {
        return this.componentGroup.getComponentMap();
    }

    public Collection<Component<?, ?>> getAllComponents() {
        ArrayList allComponents = new ArrayList();
        this.recursivelyFindAllComponents(allComponents, this);
        Collections.sort(allComponents);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void recursivelyFindAllComponents(Collection<Component<?, ?>> allComponents, TreeConfigProducer<?> current) {
        for (AnyConfigProducer child : current.getChildren().values()) {
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            if (!(child instanceof TreeConfigProducer)) continue;
            TreeConfigProducer t = (TreeConfigProducer)child;
            if (child instanceof Container) continue;
            this.recursivelyFindAllComponents(allComponents, t);
        }
    }

    public void getConfig(ComponentsConfig.Builder builder) {
        builder.setApplyOnRestart(this.getDeferChangesUntilRestart());
        builder.components.addAll(ComponentsConfigGenerator.generate(this.getAllComponents()));
        builder.components(new ComponentsConfig.Components.Builder().id("com.yahoo.container.core.config.HandlersConfigurerDi$RegistriesHack"));
    }

    public void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers.putAll(DiscBindingsConfigGenerator.generate(this.getHandlers()));
    }

    public void getConfig(DocumentmanagerConfig.Builder builder) {
        if (this.containerDocumentApi != null) {
            builder.ignoreundefinedfields(this.containerDocumentApi.ignoreUndefinedFields());
        }
    }

    public void getConfig(ContainerDocumentConfig.Builder builder) {
        for (Map.Entry<String, String> e : this.concreteDocumentTypes.entrySet()) {
            ContainerDocumentConfig.Doctype.Builder dtb = new ContainerDocumentConfig.Doctype.Builder();
            dtb.type(e.getKey());
            dtb.factorycomponent(e.getValue());
            builder.doctype(dtb);
        }
    }

    public void getConfig(HealthMonitorConfig.Builder builder) {
        Monitoring monitoring = this.getMonitoringService();
        if (monitoring != null) {
            builder.snapshot_interval((double)monitoring.getIntervalSeconds().intValue());
        }
    }

    public void getConfig(ApplicationMetadataConfig.Builder builder) {
        if (this.applicationMetaData != null) {
            builder.name(this.applicationMetaData.getApplicationId().application().value()).path(this.applicationMetaData.getDeployPath()).timestamp(this.applicationMetaData.getDeployTimestamp().longValue()).checksum(this.applicationMetaData.getChecksum()).generation(this.applicationMetaData.getGeneration().longValue());
        }
    }

    public void addCommonVespaBundles() {
        PlatformBundles.COMMON_VESPA_BUNDLES.forEach(this::addPlatformBundle);
        PlatformBundles.VESPA_SECURITY_BUNDLES.forEach(this::addPlatformBundle);
        PlatformBundles.VESPA_ZK_BUNDLES.forEach(this::addPlatformBundle);
    }

    public void addAllPlatformBundles() {
        ContainerDocumentApi.addVespaClientContainerBundle(this);
        this.addSearchAndDocprocBundles();
    }

    public void addSearchAndDocprocBundles() {
        PlatformBundles.SEARCH_AND_DOCPROC_BUNDLES.forEach(this::addPlatformBundle);
    }

    public final void addPlatformBundle(Path bundlePath) {
        if (!this.unnecessaryPlatformBundles().contains(bundlePath)) {
            this.platformBundles.add(bundlePath);
        } else {
            log.fine(() -> "Not installing bundle " + bundlePath + " for cluster " + this.getName());
        }
    }

    protected Set<Path> unnecessaryPlatformBundles() {
        return Set.of();
    }

    public void getConfig(PlatformBundlesConfig.Builder builder) {
        this.platformBundles.stream().map(Path::toString).forEach(arg_0 -> ((PlatformBundlesConfig.Builder)builder).bundlePaths(arg_0));
    }

    public void getConfig(QrSearchersConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QrStartConfig.Builder builder) {
        builder.jvm.verbosegc(false).availableProcessors(1).compressedClassSpaceSize(32).minHeapsize(32).heapsize(256).heapSizeAsPercentageOfPhysicalMemory(0).gcopts(Objects.requireNonNullElse(this.jvmGCOptions, G1GC));
    }

    public void getConfig(DocprocConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SchemamappingConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void initialize(Map<String, SearchCluster> clusterMap) {
        if (this.containerSearch != null) {
            this.containerSearch.connectSearchClusters(clusterMap);
        }
    }

    public void addAccessLog(String clusterName) {
        this.addAccessLog(Optional.ofNullable(clusterName));
    }

    public void addAccessLog(String fileNamePattern, String symlinkName) {
        this.removeSimpleComponent(VoidRequestLog.class);
        this.addSimpleComponent(AccessLog.class);
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.jsonAccessLog, this.compressionType, fileNamePattern, null, true, true, symlinkName, 1024, 262144));
    }

    protected void addAccessLog(Optional<String> clusterName) {
        this.removeSimpleComponent(VoidRequestLog.class);
        this.addSimpleComponent(AccessLog.class);
        this.addComponent(new AccessLogComponent(this, AccessLogComponent.AccessLogType.jsonAccessLog, this.compressionType, clusterName, this.isHostedVespa));
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        for (SearchCluster searchCluster : Content.getSearchClusters(this.getRoot().configModelRepo())) {
            searchCluster.getConfig(builder);
        }
    }

    public void getConfig(ClusterInfoConfig.Builder builder) {
        builder.clusterId(this.name);
        builder.nodeCount(this.containers.size());
        this.containers.forEach(c -> builder.nodeIndices(Integer.valueOf(c.index())));
        for (Service service : this.getDescendantServices()) {
            builder.services.add(new ClusterInfoConfig.Services.Builder().index(Integer.parseInt(service.getServicePropertyString("index", "99999"))).hostname(service.getHostName()).ports(this.getPorts(service)));
        }
    }

    public void getConfig(ConfigserverConfig.Builder builder) {
        builder.system(this.zone.system().value());
        builder.environment(this.zone.environment().value());
        builder.region(this.zone.region().value());
        builder.cloud(this.zone.cloud().name().value());
    }

    public void getConfig(CuratorConfig.Builder builder) {
        if (this.getParent() instanceof ConfigserverCluster) {
            return;
        }
        for (Container container : this.containers) {
            builder.server(new CuratorConfig.Server.Builder().hostname(container.getHostResource().getHostname()));
        }
        builder.zookeeperLocalhostAffinity(this.zooKeeperLocalhostAffinity);
    }

    private List<ClusterInfoConfig.Services.Ports.Builder> getPorts(Service service) {
        ArrayList<ClusterInfoConfig.Services.Ports.Builder> builders = new ArrayList<ClusterInfoConfig.Services.Ports.Builder>();
        PortsMeta portsMeta = service.getPortsMeta();
        for (int i = 0; i < portsMeta.getNumPorts(); ++i) {
            builders.add(new ClusterInfoConfig.Services.Ports.Builder().number(service.getRelativePort(i)).tags(ApplicationConfigProducerRoot.getPortTags(portsMeta, i)));
        }
        return builders;
    }

    public boolean isHostedVespa() {
        return this.isHostedVespa;
    }

    public Map<String, String> concreteDocumentTypes() {
        return this.concreteDocumentTypes;
    }

    public void setHostClusterId(String clusterId) {
        this.hostClusterId = clusterId;
    }

    public Optional<String> getHostClusterId() {
        return Optional.ofNullable(this.hostClusterId);
    }

    public void setJvmGCOptions(String opts) {
        this.jvmGCOptions = opts;
    }

    public Optional<String> getJvmGCOptions() {
        return Optional.ofNullable(this.jvmGCOptions);
    }

    public final void setRpcServerEnabled(boolean rpcServerEnabled) {
        this.rpcServerEnabled = rpcServerEnabled;
    }

    boolean rpcServerEnabled() {
        return this.rpcServerEnabled;
    }

    boolean httpServerEnabled() {
        return this.httpServerEnabled;
    }

    public void setHttpServerEnabled(boolean httpServerEnabled) {
        this.httpServerEnabled = httpServerEnabled;
    }

    public String toString() {
        return "container cluster '" + this.getName() + "'";
    }

    public void setDeferChangesUntilRestart(boolean deferChangesUntilRestart) {
        this.deferChangesUntilRestart = deferChangesUntilRestart;
    }

    public boolean getDeferChangesUntilRestart() {
        return this.deferChangesUntilRestart;
    }

    public Optional<JvmMemoryPercentage> getMemoryPercentage() {
        return Optional.empty();
    }

    public record JvmMemoryPercentage(int percentage, OptionalDouble availableMemoryGb) {
        static JvmMemoryPercentage of(int percentage) {
            return new JvmMemoryPercentage(percentage, OptionalDouble.empty());
        }

        static JvmMemoryPercentage of(int percentage, double availableMemoryGb) {
            return new JvmMemoryPercentage(percentage, OptionalDouble.of(availableMemoryGb));
        }
    }
}

