/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.derived.SummaryClassField;
import com.yahoo.schema.processing.DynamicSummaryTransformUtils;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class SummaryClass
extends Derived {
    public static final String DOCUMENT_ID_FIELD = "documentid";
    private final int id;
    private boolean accessingDiskSummary = false;
    private final boolean rawAsBase64;
    private final boolean omitSummaryFeatures;
    private final Map<String, SummaryClassField> fields;
    private final DeployLogger deployLogger;

    public SummaryClass(Schema schema, DocumentSummary summary, DeployLogger deployLogger) {
        super(summary.getName());
        this.deployLogger = deployLogger;
        this.rawAsBase64 = schema.isRawAsBase64();
        this.omitSummaryFeatures = summary.omitSummaryFeatures();
        LinkedHashMap<String, SummaryClassField> fields = new LinkedHashMap<String, SummaryClassField>();
        this.deriveFields(schema, summary, fields);
        this.deriveImplicitFields(summary, fields);
        this.fields = Collections.unmodifiableMap(fields);
        this.id = SummaryClass.deriveId(summary.getName(), fields);
    }

    public int id() {
        return this.id;
    }

    private void deriveImplicitFields(DocumentSummary summary, Map<String, SummaryClassField> fields) {
        if (summary.getName().equals("default")) {
            this.addField(DOCUMENT_ID_FIELD, (DataType)DataType.STRING, SummaryTransform.DOCUMENT_ID, "", fields);
        }
    }

    private void deriveFields(Schema schema, DocumentSummary summary, Map<String, SummaryClassField> fields) {
        for (SummaryField summaryField : summary.getSummaryFields().values()) {
            if (!this.accessingDiskSummary && schema.isAccessingDiskSummary(summaryField)) {
                this.accessingDiskSummary = true;
            }
            this.addField(summaryField.getName(), summaryField.getDataType(), summaryField.getTransform(), SummaryClass.getSource(summaryField, schema), fields);
        }
    }

    private void addField(String name, DataType type, SummaryTransform transform, String source, Map<String, SummaryClassField> fields) {
        if (fields.containsKey(name)) {
            SummaryClassField sf = fields.get(name);
            if (SummaryClassField.convertDataType(type, transform, this.rawAsBase64) != sf.getType()) {
                this.deployLogger.logApplicationPackage(Level.WARNING, "Conflicting definition of field " + name + ". Declared as type " + sf.getType() + " and " + type);
            }
        } else {
            fields.put(name, new SummaryClassField(name, type, transform, source, this.rawAsBase64));
        }
    }

    public Map<String, SummaryClassField> fields() {
        return this.fields;
    }

    private static int deriveId(String name, Map<String, SummaryClassField> fields) {
        int hash = name.hashCode();
        int number = 1;
        for (SummaryClassField field : fields.values()) {
            hash += number++ * (field.getName().hashCode() + 17 * field.getType().getName().hashCode());
        }
        if ((hash = Math.abs(hash)) == 0x55555555) {
            ++hash;
        }
        return hash;
    }

    public SummaryConfig.Classes.Builder getSummaryClassConfig() {
        SummaryConfig.Classes.Builder classBuilder = new SummaryConfig.Classes.Builder();
        classBuilder.id(this.id).name(this.getName()).omitsummaryfeatures(this.omitSummaryFeatures);
        for (SummaryClassField field : this.fields.values()) {
            classBuilder.fields(new SummaryConfig.Classes.Fields.Builder().name(field.getName()).command(field.getCommand()).source(field.getSource()));
        }
        return classBuilder;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    protected String getDerivedName() {
        return "summary";
    }

    public String toString() {
        return "summary class '" + this.getName() + "'";
    }

    static String getCommand(SummaryTransform transform) {
        if (transform == SummaryTransform.NONE) {
            return "";
        }
        if (transform == SummaryTransform.DISTANCE) {
            return "absdist";
        }
        if (transform.isDynamic()) {
            return "dynamicteaser";
        }
        return transform.getName();
    }

    static String getSource(SummaryField summaryField, Schema schema) {
        if (summaryField.getTransform() == SummaryTransform.NONE) {
            return "";
        }
        if (summaryField.getTransform() == SummaryTransform.ATTRIBUTE || summaryField.getTransform() == SummaryTransform.ATTRIBUTECOMBINER && summaryField.hasExplicitSingleSource() || summaryField.getTransform() == SummaryTransform.COPY || summaryField.getTransform() == SummaryTransform.DISTANCE || summaryField.getTransform() == SummaryTransform.GEOPOS || summaryField.getTransform() == SummaryTransform.POSITIONS || summaryField.getTransform() == SummaryTransform.MATCHED_ELEMENTS_FILTER || summaryField.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER || summaryField.getTransform() == SummaryTransform.TOKENS || summaryField.getTransform() == SummaryTransform.ATTRIBUTE_TOKENS) {
            return summaryField.getSingleSource();
        }
        if (summaryField.getTransform().isDynamic()) {
            return DynamicSummaryTransformUtils.getSource(summaryField, schema);
        }
        return "";
    }

    static boolean commandRequiringQuery(String commandName) {
        return commandName.equals("dynamicteaser") || commandName.equals(SummaryTransform.MATCHED_ELEMENTS_FILTER.getName()) || commandName.equals(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER.getName());
    }
}

