/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.config.search.summary.JuniperrcConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.SearchCluster;

public class StreamingSearchCluster
extends SearchCluster
implements AttributesConfig.Producer,
RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
RankingExpressionsConfig.Producer,
OnnxModelsConfig.Producer,
JuniperrcConfig.Producer,
SummaryConfig.Producer,
VsmsummaryConfig.Producer,
VsmfieldsConfig.Producer {
    private final String storageRouteSpec;
    private final AttributesProducer attributesConfig;
    private final String docTypeName;

    public StreamingSearchCluster(TreeConfigProducer<AnyConfigProducer> parent, String clusterName, int index, String docTypeName, String storageRouteSpec) {
        super(parent, clusterName, index);
        this.attributesConfig = new AttributesProducer(parent, docTypeName);
        this.docTypeName = docTypeName;
        this.storageRouteSpec = storageRouteSpec;
    }

    @Override
    protected SearchCluster.IndexingMode getIndexingMode() {
        return SearchCluster.IndexingMode.STREAMING;
    }

    @Override
    public final String getStorageRouteSpec() {
        return this.storageRouteSpec;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public DerivedConfiguration derived() {
        return this.db().getDerivedConfiguration();
    }

    @Override
    public void deriveFromSchemas(DeployState deployState) {
        if (this.schemas().isEmpty()) {
            return;
        }
        if (this.schemas().size() > 1) {
            throw new IllegalArgumentException("Only a single schema is supported, got " + this.schemas().size());
        }
        Schema schema = this.schemas().values().stream().findAny().get().fullSchema();
        if (!schema.getName().equals(this.docTypeName)) {
            throw new IllegalArgumentException("Document type name '" + this.docTypeName + "' must be the same as the schema name '" + schema.getName() + "'");
        }
        this.add(new DocumentDatabase(this, this.docTypeName, new DerivedConfiguration(deployState, schema, SchemaInfo.IndexMode.STREAMING)));
    }

    @Override
    protected void fillDocumentDBConfig(DocumentDatabase sdoc, ProtonConfig.Documentdb.Builder ddbB) {
        super.fillDocumentDBConfig(sdoc, ddbB);
        ddbB.configid(this.attributesConfig.getConfigId());
    }

    private DocumentDatabase db() {
        return this.getDocumentDbs().get(0);
    }

    public void getConfig(SummaryConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(JuniperrcConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(VsmfieldsConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    public void getConfig(VsmsummaryConfig.Builder builder) {
        this.db().getConfig(builder);
    }

    private class AttributesProducer
    extends AnyConfigProducer
    implements AttributesConfig.Producer {
        AttributesProducer(TreeConfigProducer<AnyConfigProducer> parent, String docType) {
            super(parent, docType);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            StreamingSearchCluster.this.derived().getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
        }
    }
}

