/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.schema.DocumentOnlySchema;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import com.yahoo.vespa.model.content.DispatchTuning;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.SearchCoverage;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndexedSearchCluster
extends SearchCluster
implements DispatchConfig.Producer,
DispatchNodesConfig.Producer {
    private Tuning tuning;
    private SearchCoverage searchCoverage;
    private final Redundancy.Provider redundancyProvider;
    private final List<SearchNode> searchNodes = new ArrayList<SearchNode>();
    private final DispatchTuning.DispatchPolicy defaultDispatchPolicy;
    private final double dispatchWarmup;
    private final String summaryDecodePolicy;

    public IndexedSearchCluster(TreeConfigProducer<AnyConfigProducer> parent, String clusterName, int index, Redundancy.Provider redundancyProvider, ModelContext.FeatureFlags featureFlags) {
        super(parent, clusterName, index);
        this.redundancyProvider = redundancyProvider;
        this.defaultDispatchPolicy = DispatchTuning.Builder.toDispatchPolicy(featureFlags.queryDispatchPolicy());
        this.dispatchWarmup = featureFlags.queryDispatchWarmup();
        this.summaryDecodePolicy = featureFlags.summaryDecodePolicy();
    }

    @Override
    protected SearchCluster.IndexingMode getIndexingMode() {
        return SearchCluster.IndexingMode.REALTIME;
    }

    public void addSearcher(SearchNode searcher) {
        this.searchNodes.add(searcher);
    }

    public List<SearchNode> getSearchNodes() {
        return Collections.unmodifiableList(this.searchNodes);
    }

    public int getSearchNodeCount() {
        return this.searchNodes.size();
    }

    public SearchNode getSearchNode(int index) {
        return this.searchNodes.get(index);
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public Tuning getTuning() {
        return this.tuning;
    }

    @Override
    public void deriveFromSchemas(DeployState deployState) {
        for (SchemaInfo spec : this.schemas().values()) {
            if (spec.fullSchema() instanceof DocumentOnlySchema) continue;
            DocumentDatabase db = new DocumentDatabase(this, spec.fullSchema().getName(), new DerivedConfiguration(deployState, spec.fullSchema(), spec.getIndexMode()));
            this.add(db);
        }
    }

    public void setSearchCoverage(SearchCoverage searchCoverage) {
        this.searchCoverage = searchCoverage;
    }

    private static DispatchConfig.DistributionPolicy.Enum toDistributionPolicy(DispatchTuning.DispatchPolicy tuning) {
        return switch (tuning) {
            default -> throw new IncompatibleClassChangeError();
            case DispatchTuning.DispatchPolicy.ADAPTIVE -> DispatchConfig.DistributionPolicy.ADAPTIVE;
            case DispatchTuning.DispatchPolicy.ROUNDROBIN -> DispatchConfig.DistributionPolicy.ROUNDROBIN;
            case DispatchTuning.DispatchPolicy.BEST_OF_RANDOM_2 -> DispatchConfig.DistributionPolicy.BEST_OF_RANDOM_2;
            case DispatchTuning.DispatchPolicy.LATENCY_AMORTIZED_OVER_REQUESTS -> DispatchConfig.DistributionPolicy.LATENCY_AMORTIZED_OVER_REQUESTS;
            case DispatchTuning.DispatchPolicy.LATENCY_AMORTIZED_OVER_TIME -> DispatchConfig.DistributionPolicy.LATENCY_AMORTIZED_OVER_TIME;
        };
    }

    public void getConfig(DispatchNodesConfig.Builder builder) {
        for (SearchNode node : this.getSearchNodes()) {
            DispatchNodesConfig.Node.Builder nodeBuilder = new DispatchNodesConfig.Node.Builder();
            nodeBuilder.key(node.getDistributionKey());
            nodeBuilder.group(node.getNodeSpec().groupIndex());
            nodeBuilder.host(node.getHostName());
            nodeBuilder.port(node.getRpcPort());
            builder.node(nodeBuilder);
        }
    }

    public void getConfig(DispatchConfig.Builder builder) {
        if (this.tuning.dispatch.getTopkProbability() != null) {
            builder.topKProbability(this.tuning.dispatch.getTopkProbability().doubleValue());
        }
        if (this.tuning.dispatch.getMinActiveDocsCoverage() != null) {
            builder.minActivedocsPercentage(this.tuning.dispatch.getMinActiveDocsCoverage().doubleValue());
        }
        if (this.tuning.dispatch.getDispatchPolicy() != null) {
            builder.distributionPolicy(IndexedSearchCluster.toDistributionPolicy(this.tuning.dispatch.getDispatchPolicy()));
        } else {
            builder.distributionPolicy(IndexedSearchCluster.toDistributionPolicy(this.defaultDispatchPolicy));
        }
        if (this.tuning.dispatch.getMaxHitsPerPartition() != null) {
            builder.maxHitsPerNode(this.tuning.dispatch.getMaxHitsPerPartition().intValue());
        }
        builder.redundancy((long)this.redundancyProvider.redundancy().finalRedundancy());
        if (this.searchCoverage != null) {
            if (this.searchCoverage.getMinimum() != null) {
                builder.minSearchCoverage(this.searchCoverage.getMinimum() * 100.0);
            }
            if (this.searchCoverage.getMinWaitAfterCoverageFactor() != null) {
                builder.minWaitAfterCoverageFactor(this.searchCoverage.getMinWaitAfterCoverageFactor().doubleValue());
            }
            if (this.searchCoverage.getMaxWaitAfterCoverageFactor() != null) {
                builder.maxWaitAfterCoverageFactor(this.searchCoverage.getMaxWaitAfterCoverageFactor().doubleValue());
            }
        }
        builder.warmuptime(this.dispatchWarmup);
        builder.summaryDecodePolicy(this.toSummaryDecoding(this.summaryDecodePolicy));
    }

    private DispatchConfig.SummaryDecodePolicy.Enum toSummaryDecoding(String summaryDecodeType) {
        return switch (summaryDecodeType.toLowerCase()) {
            case "eager" -> DispatchConfig.SummaryDecodePolicy.EAGER;
            case "ondemand", "on-demand" -> DispatchConfig.SummaryDecodePolicy.Enum.ONDEMAND;
            default -> DispatchConfig.SummaryDecodePolicy.Enum.EAGER;
        };
    }

    @Override
    public String toString() {
        return "Indexing cluster '" + this.getClusterName() + "'";
    }
}

