/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.IdentityProvider;
import com.yahoo.vespa.model.container.component.Component;

public class SecretStoreValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHosted()) {
            return;
        }
        if (context.model().getAdmin().getApplicationType() != ConfigModelContext.ApplicationType.DEFAULT) {
            return;
        }
        for (ContainerCluster containerCluster : context.model().getContainerClusters().values()) {
            if (!containerCluster.getSecretStore().isPresent() || this.hasIdentityProvider(containerCluster)) continue;
            context.illegal(String.format("Container cluster '%s' uses a secret store, so an Athenz domain and an Athenz service must be declared in deployment.xml.", containerCluster.getName()));
        }
    }

    private boolean hasIdentityProvider(ContainerCluster<? extends Container> cluster) {
        for (Component<?, ?> component : cluster.getAllComponents()) {
            if (!(component instanceof IdentityProvider)) continue;
            return true;
        }
        return false;
    }
}

