/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class StringSettingsOnNonStringFields
extends Processor {
    public StringSettingsOnNonStringFields(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            if (!this.doCheck(field)) continue;
            if (field.getMatching().isTypeUserSet()) {
                this.warn(this.schema, field, "Matching type " + field.getMatching().getType() + " is only allowed for string fields.");
            }
            if (!field.getRanking().isLiteral()) continue;
            this.warn(this.schema, field, "Rank type literal only applies to string fields");
        }
    }

    private boolean doCheck(SDField field) {
        if (field.getDataType() instanceof NumericDataType) {
            return true;
        }
        return field.getDataType() instanceof CollectionDataType && ((CollectionDataType)field.getDataType()).getNestedType() instanceof NumericDataType;
    }
}

