/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.derived.SummaryClass;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Summaries
extends Derived {
    private final boolean useV8GeoPositions;
    private final List<SummaryClass> summaries;

    public Summaries(Schema schema, DeployLogger deployLogger, ModelContext.FeatureFlags featureFlags) {
        this.useV8GeoPositions = featureFlags.useV8GeoPositions();
        ArrayList<SummaryClass> summaries = new ArrayList<SummaryClass>();
        summaries.add(new SummaryClass(schema, schema.getSummary("default"), deployLogger));
        for (DocumentSummary summary : schema.getSummaries().values()) {
            if (summary.getName().equals("default")) continue;
            summaries.add(new SummaryClass(schema, summary, deployLogger));
        }
        this.summaries = List.copyOf(summaries);
    }

    public List<SummaryClass> asList() {
        return this.summaries;
    }

    @Override
    protected String getDerivedName() {
        return "summary";
    }

    public void getConfig(SummaryConfig.Builder builder) {
        builder.defaultsummaryid(this.summaries.isEmpty() ? -1 : this.summaries.get(0).hashCode());
        builder.usev8geopositions(this.useV8GeoPositions);
        builder.classes(this.summaries.stream().map(SummaryClass::getSummaryClassConfig).toList());
    }

    public void export(String toDirectory) throws IOException {
        SummaryConfig.Builder builder = new SummaryConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }
}

