/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.http.HttpFilterConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class FilterConfigProvider
extends SimpleComponent
implements HttpFilterConfig.Producer {
    private static final ComponentSpecification filterConfigProviderClass = ComponentSpecification.fromString((String)com.yahoo.container.FilterConfigProvider.class.getName());
    private final ChainedComponentModel filterModel;
    private HashMap<String, String> configMap = new LinkedHashMap<String, String>();

    public FilterConfigProvider(ChainedComponentModel filterModel) {
        super(new ComponentModel(new BundleInstantiationSpecification(FilterConfigProvider.configProviderId(filterModel.getComponentId()), filterConfigProviderClass, null)));
        this.filterModel = filterModel;
    }

    public void getConfig(HttpFilterConfig.Builder builder) {
        builder.filterName(this.filterModel.getComponentId().stringValue()).filterClass(this.filterModel.getClassId().stringValue());
        for (Map.Entry<String, String> param : this.configMap.entrySet()) {
            builder.param(new HttpFilterConfig.Param.Builder().name(param.getKey()).value(param.getValue()));
        }
    }

    public String putConfig(String key, String value) {
        return this.configMap.put(key, value);
    }

    static ComponentId configProviderId(ComponentId filterId) {
        return ComponentId.fromString((String)"filterConfig").nestInNamespace(filterId);
    }
}

