/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.docproc.AbstractConcreteDocumentFactory;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.SimpleDocumentProcessor;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.prelude.cluster.ClusterSearcher;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.prelude.querytransform.CJKSearcher;
import com.yahoo.prelude.querytransform.CollapsePhraseSearcher;
import com.yahoo.prelude.querytransform.LiteralBoostSearcher;
import com.yahoo.prelude.querytransform.NoRankingSearcher;
import com.yahoo.prelude.querytransform.NonPhrasingSearcher;
import com.yahoo.prelude.querytransform.NormalizingSearcher;
import com.yahoo.prelude.querytransform.PhrasingSearcher;
import com.yahoo.prelude.querytransform.RecallSearcher;
import com.yahoo.prelude.querytransform.StemmingSearcher;
import com.yahoo.prelude.searcher.BlendingSearcher;
import com.yahoo.prelude.searcher.FieldCollapsingSearcher;
import com.yahoo.prelude.searcher.FillSearcher;
import com.yahoo.prelude.searcher.JSONDebugSearcher;
import com.yahoo.prelude.searcher.JuniperSearcher;
import com.yahoo.prelude.searcher.MultipleResultsSearcher;
import com.yahoo.prelude.searcher.PosSearcher;
import com.yahoo.prelude.searcher.QuotingSearcher;
import com.yahoo.prelude.searcher.ValidateSortingSearcher;
import com.yahoo.prelude.semantics.SemanticSearcher;
import com.yahoo.prelude.statistics.StatisticsSearcher;
import com.yahoo.search.Searcher;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.federation.FederationSearcher;
import com.yahoo.search.federation.ForwardingSearcher;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.grouping.GroupingValidator;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.pagetemplates.PageTemplate;
import com.yahoo.search.pagetemplates.PageTemplateSearcher;
import com.yahoo.search.pagetemplates.engine.Resolver;
import com.yahoo.search.pagetemplates.engine.resolvers.DeterministicResolver;
import com.yahoo.search.pagetemplates.engine.resolvers.RandomResolver;
import com.yahoo.search.query.rewrite.QueryRewriteSearcher;
import com.yahoo.search.query.rewrite.SearchChainDispatcherSearcher;
import com.yahoo.search.query.rewrite.rewriters.GenericExpansionRewriter;
import com.yahoo.search.query.rewrite.rewriters.MisspellRewriter;
import com.yahoo.search.query.rewrite.rewriters.NameRewriter;
import com.yahoo.search.querytransform.AllLowercasingSearcher;
import com.yahoo.search.querytransform.DefaultPositionSearcher;
import com.yahoo.search.querytransform.LowercasingSearcher;
import com.yahoo.search.querytransform.NGramSearcher;
import com.yahoo.search.querytransform.VespaLowercasingSearcher;
import com.yahoo.search.rendering.Renderer;
import com.yahoo.search.rendering.SectionedRenderer;
import com.yahoo.search.searchchain.ForkingSearcher;
import com.yahoo.search.searchers.CacheControlSearcher;
import com.yahoo.search.searchers.RateLimitingSearcher;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.streamingvisitors.MetricsSearcher;
import com.yahoo.vespa.streamingvisitors.StreamingSearcher;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlatformBundles {
    public static final Path LIBRARY_PATH = Paths.get(Defaults.getDefaults().underVespaHome("lib/jars"), new String[0]);
    public static final String SEARCH_AND_DOCPROC_BUNDLE = "container-search-and-docproc";
    public static final Set<Path> COMMON_VESPA_BUNDLES = PlatformBundles.toBundlePaths("container-spifly.jar", "javax.servlet-api-3.1.0.jar");
    public static final Set<Path> VESPA_SECURITY_BUNDLES = PlatformBundles.toBundlePaths("jdisc-security-filters", "vespa-athenz");
    public static final Set<Path> VESPA_ZK_BUNDLES = PlatformBundles.toBundlePaths("zkfacade", "zookeeper-server");
    public static final Set<Path> SEARCH_AND_DOCPROC_BUNDLES = PlatformBundles.toBundlePaths("container-search-and-docproc", "docprocs", "linguistics-components", "model-evaluation", "model-integration", "container-onnxruntime.jar");
    private static final Set<String> searchAndDocprocComponents = Set.of(AbstractConcreteDocumentFactory.class.getName(), DocumentProcessor.class.getName(), SimpleDocumentProcessor.class.getName(), SimpleLinguistics.class.getName(), ClusterSearcher.class.getName(), FastSearcher.class.getName(), VespaBackEndSearcher.class.getName(), CJKSearcher.class.getName(), CollapsePhraseSearcher.class.getName(), LiteralBoostSearcher.class.getName(), NoRankingSearcher.class.getName(), NonPhrasingSearcher.class.getName(), NormalizingSearcher.class.getName(), PhrasingSearcher.class.getName(), RecallSearcher.class.getName(), StemmingSearcher.class.getName(), BlendingSearcher.class.getName(), FieldCollapsingSearcher.class.getName(), FillSearcher.class.getName(), JSONDebugSearcher.class.getName(), JuniperSearcher.class.getName(), MultipleResultsSearcher.class.getName(), PosSearcher.class.getName(), QuotingSearcher.class.getName(), ValidateSortingSearcher.class.getName(), SemanticSearcher.class.getName(), StatisticsSearcher.class.getName(), Searcher.class.getName(), com.yahoo.search.cluster.ClusterSearcher.class.getName(), PingableSearcher.class.getName(), FederationSearcher.class.getName(), ForwardingSearcher.class.getName(), GroupingQueryParser.class.getName(), GroupingValidator.class.getName(), GroupingExecutor.class.getName(), PageTemplate.class.getName(), PageTemplateSearcher.class.getName(), Resolver.class.getName(), DeterministicResolver.class.getName(), RandomResolver.class.getName(), com.yahoo.search.pagetemplates.model.Renderer.class.getName(), QueryRewriteSearcher.class.getName(), SearchChainDispatcherSearcher.class.getName(), GenericExpansionRewriter.class.getName(), MisspellRewriter.class.getName(), NameRewriter.class.getName(), AllLowercasingSearcher.class.getName(), DefaultPositionSearcher.class.getName(), LowercasingSearcher.class.getName(), NGramSearcher.class.getName(), VespaLowercasingSearcher.class.getName(), Renderer.class.getName(), SectionedRenderer.class.getName(), ForkingSearcher.class.getName(), CacheControlSearcher.class.getName(), RateLimitingSearcher.class.getName(), MetricsSearcher.class.getName(), StreamingSearcher.class.getName());

    private static Set<Path> toBundlePaths(String ... bundleNames) {
        return Stream.of(bundleNames).map(PlatformBundles::absoluteBundlePath).collect(Collectors.toSet());
    }

    public static Path absoluteBundlePath(String fileName) {
        return PlatformBundles.absoluteBundlePath(fileName, JarSuffix.JAR_WITH_DEPS);
    }

    public static Path absoluteBundlePath(String fileName, JarSuffix jarSuffix) {
        if (fileName == null) {
            return null;
        }
        String fullFilename = fileName.endsWith(".jar") ? fileName : fileName + jarSuffix.suffix;
        return LIBRARY_PATH.resolve(Paths.get(fullFilename, new String[0]));
    }

    public static boolean isSearchAndDocprocClass(String className) {
        return searchAndDocprocComponents.contains(className);
    }

    private static enum JarSuffix {
        JAR_WITH_DEPS("-jar-with-dependencies.jar"),
        DEPLOY("-deploy.jar");

        public final String suffix;

        private JarSuffix(String suffix) {
            this.suffix = suffix;
        }
    }
}

