/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.config.provision.ProvisionLogger;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostSystem
extends TreeConfigProducer<Host> {
    private static final Logger log = Logger.getLogger(HostSystem.class.getName());
    private static final boolean doCheckIp;
    private final Map<String, HostResource> hostname2host = new LinkedHashMap<String, HostResource>();
    private final HostProvisioner provisioner;
    private final DeployLogger deployLogger;
    private final boolean isHosted;

    public HostSystem(TreeConfigProducer<AnyConfigProducer> parent, String name, HostProvisioner provisioner, DeployLogger deployLogger, boolean isHosted) {
        super(parent, name);
        this.provisioner = provisioner;
        this.deployLogger = deployLogger;
        this.isHosted = isHosted;
    }

    String checkHostname(String hostname) {
        if (this.isHosted) {
            return hostname;
        }
        if (doCheckIp) {
            BiConsumer<Level, String> logFunction = (arg_0, arg_1) -> ((DeployLogger)this.deployLogger).logApplicationPackage(arg_0, arg_1);
            try {
                InetAddress inetAddr = InetAddress.getByName(hostname);
                String canonical = inetAddr.getCanonicalHostName();
                if (!hostname.equals(canonical)) {
                    logFunction.accept(Level.WARNING, "Host named '" + hostname + "' may not receive any config since it differs from its canonical hostname '" + canonical + "' (check DNS and /etc/hosts).");
                }
            }
            catch (UnknownHostException e) {
                logFunction.accept(Level.WARNING, "Unable to lookup IP address of host: " + hostname);
            }
        }
        return hostname;
    }

    public String toString() {
        return "hosts [" + this.hostname2host.values().stream().map(HostResource::getHostname).collect(Collectors.joining(", ")) + "]";
    }

    public HostResource getHost(String hostAlias) {
        HostSpec hostSpec = this.provisioner.allocateHost(hostAlias);
        HostResource resource = this.hostname2host.get(hostSpec.hostname());
        return resource != null ? resource : this.addNewHost(hostSpec);
    }

    private HostResource addNewHost(HostSpec hostSpec) {
        String hostname = this.checkHostname(hostSpec.hostname());
        HostResource hostResource = new HostResource(Host.createHost(this, hostname), hostSpec);
        hostSpec.networkPorts().ifPresent(np -> hostResource.ports().addNetworkPorts((NetworkPorts)np));
        this.hostname2host.put(hostname, hostResource);
        return hostResource;
    }

    public List<HostResource> getHosts() {
        return this.hostname2host.values().stream().filter(host -> !host.getHost().runsConfigServer()).toList();
    }

    public List<HostResource> getAllHosts() {
        return this.hostname2host.values().stream().toList();
    }

    public void dumpPortAllocations() {
        for (HostResource hr : this.getHosts()) {
            hr.ports().flushPortReservations();
        }
    }

    public Map<HostResource, ClusterMembership> allocateHosts(ClusterSpec cluster, Capacity capacity, DeployLogger logger) {
        List allocatedHosts = this.provisioner.prepare(cluster, capacity, (ProvisionLogger)new ProvisionDeployLogger(logger));
        LinkedHashMap<HostResource, ClusterMembership> retAllocatedHosts = new LinkedHashMap<HostResource, ClusterMembership>();
        for (HostSpec spec : allocatedHosts) {
            HostResource host2 = this.getExistingHost(spec).orElseGet(() -> this.addNewHost(spec));
            retAllocatedHosts.put(host2, spec.membership().orElse(null));
        }
        retAllocatedHosts.keySet().forEach(host -> log.log(Level.FINE, () -> "Allocated host " + host.getHostname() + " with resources " + host.advertisedResources()));
        return retAllocatedHosts;
    }

    private Optional<HostResource> getExistingHost(HostSpec key) {
        List<HostResource> hosts = this.hostname2host.values().stream().filter(resource -> resource.getHostname().equals(key.hostname())).toList();
        if (hosts.isEmpty()) {
            return Optional.empty();
        }
        log.log(Level.FINE, () -> "Found existing host resource for " + key.hostname() + " with resources" + ((HostResource)hosts.get(0)).advertisedResources());
        return Optional.of(hosts.get(0));
    }

    public void addBoundHost(HostResource host) {
        this.hostname2host.put(host.getHostname(), host);
    }

    Set<HostSpec> getHostSpecs() {
        return this.getHosts().stream().map(HostResource::spec).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static {
        String checkIpProperty = System.getProperty("config_model.ip_check", "true");
        doCheckIp = !checkIpProperty.equalsIgnoreCase("false");
    }

    private static class ProvisionDeployLogger
    implements ProvisionLogger {
        private final DeployLogger deployLogger;

        public ProvisionDeployLogger(DeployLogger deployLogger) {
            this.deployLogger = deployLogger;
        }

        public void log(Level level, String message) {
            this.deployLogger.log(level, message);
        }

        public void logApplicationPackage(Level level, String message) {
            this.deployLogger.logApplicationPackage(level, message);
        }
    }
}

