/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.MatchType;
import java.io.Serializable;
import java.util.Objects;
import java.util.OptionalInt;

public class Matching
implements Cloneable,
Serializable {
    public static final MatchType defaultType = MatchType.TEXT;
    private MatchType type = MatchType.TEXT;
    private Case casing = Case.UNCASED;
    private MatchAlgorithm algorithm = MatchAlgorithm.NORMAL;
    private boolean typeUserSet = false;
    private boolean algorithmUserSet = false;
    private OptionalInt gramSize = OptionalInt.empty();
    private Integer maxLength;
    private Integer maxTermOccurrences;
    private String exactMatchTerminator = null;

    public Matching() {
    }

    public Matching(MatchType type) {
        this.type = type;
    }

    public MatchType getType() {
        return this.type;
    }

    public Case getCase() {
        return this.casing;
    }

    public Matching setType(MatchType type) {
        this.type = type;
        this.typeUserSet = true;
        return this;
    }

    public Matching setCase(Case casing) {
        this.casing = casing;
        return this;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public Matching maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer maxTermOccurrences() {
        return this.maxTermOccurrences;
    }

    public Matching maxTermOccurrences(int maxTermOccurrences) {
        this.maxTermOccurrences = maxTermOccurrences;
        return this;
    }

    public boolean isTypeUserSet() {
        return this.typeUserSet;
    }

    public MatchAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(MatchAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.algorithmUserSet = true;
    }

    public boolean isAlgorithmUserSet() {
        return this.algorithmUserSet;
    }

    public boolean isPrefix() {
        return this.algorithm == MatchAlgorithm.PREFIX;
    }

    public boolean isSubstring() {
        return this.algorithm == MatchAlgorithm.SUBSTRING;
    }

    public boolean isSuffix() {
        return this.algorithm == MatchAlgorithm.SUFFIX;
    }

    public OptionalInt getGramSize() {
        return this.gramSize;
    }

    public void setGramSize(int gramSize) {
        this.gramSize = OptionalInt.of(gramSize);
    }

    public void merge(Matching m) {
        if (m == null) {
            return;
        }
        if (m.isAlgorithmUserSet()) {
            this.setAlgorithm(m.getAlgorithm());
        }
        if (m.isTypeUserSet()) {
            this.setType(m.getType());
            if (m.getType() == MatchType.GRAM) {
                this.gramSize = m.gramSize;
            }
        }
        if (m.getExactMatchTerminator() != null) {
            this.setExactMatchTerminator(m.getExactMatchTerminator());
        }
    }

    public String getExactMatchTerminator() {
        return this.exactMatchTerminator;
    }

    public void setExactMatchTerminator(String exactMatchTerminator) {
        this.exactMatchTerminator = exactMatchTerminator;
    }

    public String toString() {
        return this.type + " matching [" + (this.type == MatchType.GRAM ? "gram size " + this.gramSize.orElse(2) : "supports " + this.algorithm) + "], [exact-terminator " + this.exactMatchTerminator + "]";
    }

    public Matching clone() {
        try {
            return (Matching)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matching)) {
            return false;
        }
        Matching other = (Matching)o;
        if (!other.type.equals((Object)this.type)) {
            return false;
        }
        if (!other.algorithm.equals((Object)this.algorithm)) {
            return false;
        }
        if (this.exactMatchTerminator == null && other.exactMatchTerminator != null) {
            return false;
        }
        if (this.exactMatchTerminator != null && !this.exactMatchTerminator.equals(other.exactMatchTerminator)) {
            return false;
        }
        return this.gramSize.equals(other.gramSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.algorithm, this.exactMatchTerminator, this.gramSize});
    }
}

