/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.collections.Pair;
import com.yahoo.compress.Compressor;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.schema.FeatureNames;
import com.yahoo.schema.LargeRankingExpressions;
import com.yahoo.schema.MapEvaluationTypeContext;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankingExpressionBody;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.FieldRankSettings;
import com.yahoo.schema.derived.NativeRankTypeDefinition;
import com.yahoo.schema.derived.NativeRankTypeDefinitionSet;
import com.yahoo.schema.derived.NativeTable;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.expressiontransforms.OnnxModelTransformer;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;

public class RawRankProfile
implements RankProfilesConfig.Producer {
    private static final Compressor compressor = new Compressor();
    private static final String keyEndMarker = "\r=";
    private static final String valueEndMarker = "\r\n";
    private final String name;
    private final Compressor.Compression compressedProperties;
    private final Map<String, RankProfile.RankFeatureNormalizer> featureNormalizers;
    private final Collection<RankProfile.Constant> constants;
    private final Collection<OnnxModel> onnxModels;

    public RawRankProfile(RankProfile rankProfile, LargeRankingExpressions largeExpressions, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, AttributeFields attributeFields, ModelContext.Properties deployProperties) {
        this.name = rankProfile.name();
        RankProfile compiled = rankProfile.compile(queryProfiles, importedModels);
        this.constants = compiled.constants().values();
        this.onnxModels = compiled.onnxModels().values();
        Deriver deriver = new Deriver(compiled, attributeFields, deployProperties, queryProfiles);
        this.compressedProperties = this.compress(deriver.derive(largeExpressions));
        this.featureNormalizers = compiled.getFeatureNormalizers();
    }

    public Collection<RankProfile.Constant> constants() {
        return this.constants;
    }

    public Collection<OnnxModel> onnxModels() {
        return this.onnxModels;
    }

    private Compressor.Compression compress(List<Pair<String, String>> properties) {
        StringBuilder b = new StringBuilder();
        for (Pair<String, String> property : properties) {
            b.append((String)property.getFirst()).append(keyEndMarker).append((String)property.getSecond()).append(valueEndMarker);
        }
        return compressor.compress(b.toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<Pair<String, String>> decompress(Compressor.Compression compression) {
        String propertiesString = new String(compressor.decompress(compression), StandardCharsets.UTF_8);
        if (propertiesString.isEmpty()) {
            return List.of();
        }
        ArrayList<Pair> properties = new ArrayList<Pair>();
        int pos = 0;
        while (pos < propertiesString.length()) {
            int keyEndPos = propertiesString.indexOf(keyEndMarker, pos);
            String key = propertiesString.substring(pos, keyEndPos);
            pos = keyEndPos + keyEndMarker.length();
            int valueEndPos = propertiesString.indexOf(valueEndMarker, pos);
            String value = propertiesString.substring(pos, valueEndPos);
            pos = valueEndPos + valueEndMarker.length();
            properties.add(new Pair((Object)key, (Object)value));
        }
        return List.copyOf(properties);
    }

    public String getName() {
        return this.name;
    }

    private void getRankProperties(RankProfilesConfig.Rankprofile.Builder b) {
        RankProfilesConfig.Rankprofile.Fef.Builder fefB = new RankProfilesConfig.Rankprofile.Fef.Builder();
        for (Pair<String, String> p : this.decompress(this.compressedProperties)) {
            fefB.property(new RankProfilesConfig.Rankprofile.Fef.Property.Builder().name((String)p.getFirst()).value((String)p.getSecond()));
        }
        b.fef(fefB);
    }

    private void buildNormalizers(RankProfilesConfig.Rankprofile.Builder b) {
        for (RankProfile.RankFeatureNormalizer normalizer : this.featureNormalizers.values()) {
            RankProfilesConfig.Rankprofile.Normalizer.Builder nBuilder = new RankProfilesConfig.Rankprofile.Normalizer.Builder();
            nBuilder.name(normalizer.name());
            nBuilder.input(normalizer.input());
            RankProfilesConfig.Rankprofile.Normalizer.Algo.Enum algo = RankProfilesConfig.Rankprofile.Normalizer.Algo.Enum.valueOf((String)normalizer.algo());
            nBuilder.algo(algo);
            nBuilder.kparam(normalizer.kparam());
            b.normalizer(nBuilder);
        }
    }

    public List<Pair<String, String>> configProperties() {
        return this.decompress(this.compressedProperties);
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        RankProfilesConfig.Rankprofile.Builder b = new RankProfilesConfig.Rankprofile.Builder().name(this.getName());
        this.getRankProperties(b);
        this.buildNormalizers(b);
        builder.rankprofile(b);
    }

    public String toString() {
        return " rank profile " + this.name;
    }

    private static class Deriver {
        private final Map<String, FieldRankSettings> fieldRankSettings = new LinkedHashMap<String, FieldRankSettings>();
        private final Set<ReferenceNode> summaryFeatures;
        private final Set<ReferenceNode> matchFeatures;
        private final Set<ReferenceNode> hiddenMatchFeatures;
        private final Set<ReferenceNode> rankFeatures;
        private final Map<String, String> featureRenames = new LinkedHashMap<String, String>();
        private final List<RankProfile.RankProperty> rankProperties;
        private final List<RankProfile.RankProperty> boostAndWeightRankProperties = new ArrayList<RankProfile.RankProperty>();
        private final boolean ignoreDefaultRankFeatures;
        private final RankProfile.MatchPhaseSettings matchPhaseSettings;
        private final int rerankCount;
        private final int keepRankCount;
        private final int numThreadsPerSearch;
        private final int minHitsPerThread;
        private final int numSearchPartitions;
        private final double termwiseLimit;
        private final OptionalDouble postFilterThreshold;
        private final OptionalDouble approximateThreshold;
        private final OptionalDouble targetHitsMaxAdjustmentFactor;
        private final double rankScoreDropLimit;
        private final boolean sortBlueprintsByCost;
        private final boolean alwaysMarkPhraseExpensive;
        private final NativeRankTypeDefinitionSet nativeRankTypeDefinitions = new NativeRankTypeDefinitionSet("default");
        private final Map<String, String> attributeTypes;
        private final Map<Reference, RankProfile.Input> inputs;
        private final Set<String> filterFields = new LinkedHashSet<String>();
        private final String rankprofileName;
        private RankingExpression firstPhaseRanking;
        private RankingExpression secondPhaseRanking;
        private RankingExpression globalPhaseRanking;
        private final int globalPhaseRerankCount;
        private final SerializationContext functionSerializationContext;

        Deriver(RankProfile compiled, AttributeFields attributeFields, ModelContext.Properties deployProperties, QueryProfileRegistry queryProfiles) {
            this.rankprofileName = compiled.name();
            this.attributeTypes = compiled.getAttributeTypes();
            this.inputs = compiled.inputs();
            this.firstPhaseRanking = compiled.getFirstPhaseRanking();
            this.secondPhaseRanking = compiled.getSecondPhaseRanking();
            this.globalPhaseRanking = compiled.getGlobalPhaseRanking();
            this.summaryFeatures = new LinkedHashSet<ReferenceNode>(compiled.getSummaryFeatures());
            this.matchFeatures = new LinkedHashSet<ReferenceNode>(compiled.getMatchFeatures());
            this.hiddenMatchFeatures = compiled.getHiddenMatchFeatures();
            this.matchFeatures.addAll(this.hiddenMatchFeatures);
            this.rankFeatures = compiled.getRankFeatures();
            this.rerankCount = compiled.getRerankCount();
            this.globalPhaseRerankCount = compiled.getGlobalPhaseRerankCount();
            this.matchPhaseSettings = compiled.getMatchPhaseSettings();
            this.numThreadsPerSearch = compiled.getNumThreadsPerSearch();
            this.minHitsPerThread = compiled.getMinHitsPerThread();
            this.numSearchPartitions = compiled.getNumSearchPartitions();
            this.termwiseLimit = compiled.getTermwiseLimit().orElse(deployProperties.featureFlags().defaultTermwiseLimit());
            this.sortBlueprintsByCost = deployProperties.featureFlags().sortBlueprintsByCost();
            this.alwaysMarkPhraseExpensive = deployProperties.featureFlags().alwaysMarkPhraseExpensive();
            this.postFilterThreshold = compiled.getPostFilterThreshold();
            this.approximateThreshold = compiled.getApproximateThreshold();
            this.targetHitsMaxAdjustmentFactor = compiled.getTargetHitsMaxAdjustmentFactor();
            this.keepRankCount = compiled.getKeepRankCount();
            this.rankScoreDropLimit = compiled.getRankScoreDropLimit();
            this.ignoreDefaultRankFeatures = compiled.getIgnoreDefaultRankFeatures();
            this.rankProperties = new ArrayList<RankProfile.RankProperty>(compiled.getRankProperties());
            Map<String, RankProfile.RankingExpressionFunction> functions = compiled.getFunctions();
            List<ExpressionFunction> functionExpressions = functions.values().stream().map(RankProfile.RankingExpressionFunction::function).toList();
            LinkedHashMap<String, String> functionProperties = new LinkedHashMap<String, String>();
            MapEvaluationTypeContext typeContext = compiled.typeContext(queryProfiles);
            this.functionSerializationContext = new SerializationContext(functionExpressions, Map.of(), (TypeContext)typeContext);
            if (this.firstPhaseRanking != null) {
                functionProperties.putAll(this.firstPhaseRanking.getRankProperties(this.functionSerializationContext));
            }
            if (this.secondPhaseRanking != null) {
                functionProperties.putAll(this.secondPhaseRanking.getRankProperties(this.functionSerializationContext));
            }
            if (this.globalPhaseRanking != null) {
                functionProperties.putAll(this.globalPhaseRanking.getRankProperties(this.functionSerializationContext));
            }
            this.deriveFeatureDeclarations(this.matchFeatures, typeContext, functionProperties);
            this.deriveFeatureDeclarations(this.summaryFeatures, typeContext, functionProperties);
            this.derivePropertiesAndFeaturesFromFunctions(functions, functionProperties, this.functionSerializationContext);
            this.deriveOnnxModelFunctionsAndFeatures(compiled);
            this.deriveRankTypeSetting(compiled, attributeFields);
            this.deriveFilterFields(compiled);
            this.deriveWeightProperties(compiled);
        }

        private void deriveFeatureDeclarations(Collection<ReferenceNode> features, TypeContext typeContext, Map<String, String> functionProperties) {
            for (ReferenceNode feature : features) {
                TensorType tt = feature.type(typeContext);
                if (tt == null || tt.rank() <= 0) continue;
                String k = "vespa.type.feature." + feature.getName() + feature.getArguments();
                functionProperties.put(k, tt.toString());
            }
        }

        private void deriveFilterFields(RankProfile rp) {
            this.filterFields.addAll(rp.allFilterFields());
        }

        private void derivePropertiesAndFeaturesFromFunctions(Map<String, RankProfile.RankingExpressionFunction> functions, Map<String, String> functionProperties, SerializationContext functionContext) {
            this.replaceFunctionFeatures(this.summaryFeatures, functionContext);
            this.replaceFunctionFeatures(this.matchFeatures, functionContext);
            this.deriveFunctionProperties(functions, functionProperties, functionContext);
            for (Map.Entry<String, String> e : functionProperties.entrySet()) {
                this.rankProperties.add(new RankProfile.RankProperty(e.getKey(), e.getValue()));
            }
        }

        private void deriveFunctionProperties(Map<String, RankProfile.RankingExpressionFunction> functions, Map<String, String> functionProperties, SerializationContext context) {
            for (Map.Entry<String, RankProfile.RankingExpressionFunction> e : functions.entrySet()) {
                String propertyName = RankingExpression.propertyName((String)e.getKey());
                if (!context.serializedFunctions().containsKey(propertyName)) {
                    String expressionString = e.getValue().function().getBody().getRoot().toString(context).toString();
                    context.addFunctionSerialization(propertyName, expressionString);
                    e.getValue().function().argumentTypes().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(argumentType -> context.addArgumentTypeSerialization((String)e.getKey(), (String)argumentType.getKey(), (TensorType)argumentType.getValue()));
                }
                e.getValue().function().returnType().ifPresent(t -> context.addFunctionTypeSerialization((String)e.getKey(), t));
            }
            functionProperties.putAll(context.serializedFunctions());
        }

        private void replaceFunctionFeatures(Set<ReferenceNode> features, SerializationContext context) {
            if (features == null) {
                return;
            }
            LinkedHashSet<ReferenceNode> functionFeatures = new LinkedHashSet<ReferenceNode>();
            Iterator<ReferenceNode> i = features.iterator();
            while (i.hasNext()) {
                Arguments useArgs;
                ReferenceNode referenceNode = i.next();
                ExpressionFunction function = context.getFunction(referenceNode.getName());
                if (function == null) continue;
                if (referenceNode.getOutput() != null) {
                    throw new IllegalArgumentException("function " + referenceNode.getName() + " cannot provide output " + referenceNode.getOutput() + " demanded by feature " + referenceNode);
                }
                int needArgs = function.arguments().size();
                if (needArgs != (useArgs = referenceNode.getArguments()).size()) {
                    throw new IllegalArgumentException("function " + referenceNode.getName() + " needs " + needArgs + " arguments but gets " + useArgs.size() + " from feature " + referenceNode);
                }
                ExpressionFunction.Instance instance = function.expand(context, useArgs.expressions(), new ArrayDeque());
                String propertyName = RankingExpression.propertyName((String)instance.getName());
                String expressionString = instance.getExpressionString();
                context.addFunctionSerialization(propertyName, expressionString);
                function.returnType().ifPresent(t -> context.addFunctionTypeSerialization(instance.getName(), t));
                String backendReference = Reference.wrapInRankingExpression((String)instance.getName());
                ReferenceNode backendReferenceNode = new ReferenceNode(backendReference, List.of(), null);
                this.featureRenames.put(backendReference, referenceNode.toString());
                functionFeatures.add(backendReferenceNode);
                i.remove();
            }
            for (ReferenceNode mappedFun : functionFeatures) {
                features.add(mappedFun);
            }
        }

        private void deriveWeightProperties(RankProfile rankProfile) {
            for (RankProfile.RankSetting setting : rankProfile.rankSettings()) {
                if (setting.getType() != RankProfile.RankSetting.Type.WEIGHT) continue;
                this.boostAndWeightRankProperties.add(new RankProfile.RankProperty("vespa.fieldweight." + setting.getFieldName(), String.valueOf(setting.getIntValue())));
            }
        }

        private void deriveRankTypeSetting(RankProfile rankProfile, AttributeFields attributeFields) {
            Iterator<RankProfile.RankSetting> i = rankProfile.rankSettingIterator();
            while (i.hasNext()) {
                RankProfile.RankSetting setting = i.next();
                if (setting.getType() != RankProfile.RankSetting.Type.RANKTYPE) continue;
                this.deriveNativeRankTypeSetting(setting.getFieldName(), (RankType)((Object)setting.getValue()), attributeFields, this.hasDefaultRankTypeSetting(rankProfile, setting.getFieldName()));
            }
        }

        private void deriveNativeRankTypeSetting(String fieldName, RankType rankType, AttributeFields attributeFields, boolean isDefaultSetting) {
            if (isDefaultSetting) {
                return;
            }
            NativeRankTypeDefinition definition = this.nativeRankTypeDefinitions.getRankTypeDefinition(rankType);
            if (definition == null) {
                throw new IllegalArgumentException("In field '" + fieldName + "': " + rankType + " is known but has no implementation. Supported rank types: " + this.nativeRankTypeDefinitions.types().keySet());
            }
            FieldRankSettings settings = this.deriveFieldRankSettings(fieldName);
            Iterator<NativeTable> i = definition.rankSettingIterator();
            while (i.hasNext()) {
                NativeTable table = i.next();
                if ((!FieldRankSettings.isIndexFieldTable(table) || attributeFields.getAttribute(fieldName) != null) && (!FieldRankSettings.isAttributeFieldTable(table) || attributeFields.getAttribute(fieldName) == null)) continue;
                settings.addTable(table);
            }
        }

        private boolean hasDefaultRankTypeSetting(RankProfile rankProfile, String fieldName) {
            RankProfile.RankSetting setting = rankProfile.getRankSetting(fieldName, RankProfile.RankSetting.Type.RANKTYPE);
            return setting != null && setting.getValue().equals((Object)RankType.DEFAULT);
        }

        private FieldRankSettings deriveFieldRankSettings(String fieldName) {
            FieldRankSettings settings = this.fieldRankSettings.get(fieldName);
            if (settings == null) {
                settings = new FieldRankSettings(fieldName);
                this.fieldRankSettings.put(fieldName, settings);
            }
            return settings;
        }

        public List<Pair<String, String>> derive(LargeRankingExpressions largeRankingExpressions) {
            ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
            for (RankProfile.RankProperty rankProperty : this.rankProperties) {
                if (RankingExpression.propertyName((String)"firstphase").equals(rankProperty.getName())) {
                    try {
                        this.firstPhaseRanking = new RankingExpression(rankProperty.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse first phase expression", e);
                    }
                }
                if (RankingExpression.propertyName((String)"secondphase").equals(rankProperty.getName())) {
                    try {
                        this.secondPhaseRanking = new RankingExpression(rankProperty.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse second phase expression", e);
                    }
                }
                if (RankingExpression.propertyName((String)"globalphase").equals(rankProperty.getName())) {
                    try {
                        this.globalPhaseRanking = new RankingExpression(rankProperty.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse global-phase expression", e);
                    }
                }
                properties.add(new Pair((Object)rankProperty.getName(), (Object)rankProperty.getValue()));
            }
            properties.addAll(this.deriveRankingPhaseRankProperties(this.firstPhaseRanking, "firstphase"));
            properties.addAll(this.deriveRankingPhaseRankProperties(this.secondPhaseRanking, "secondphase"));
            properties.addAll(this.deriveRankingPhaseRankProperties(this.globalPhaseRanking, "globalphase"));
            for (FieldRankSettings fieldRankSettings : this.fieldRankSettings.values()) {
                properties.addAll(fieldRankSettings.deriveRankProperties());
            }
            for (RankProfile.RankProperty rankProperty : this.boostAndWeightRankProperties) {
                properties.add(new Pair((Object)rankProperty.getName(), (Object)rankProperty.getValue()));
            }
            for (ReferenceNode referenceNode : this.summaryFeatures) {
                properties.add(new Pair((Object)"vespa.summary.feature", (Object)referenceNode.toString()));
            }
            for (ReferenceNode referenceNode : this.matchFeatures) {
                properties.add(new Pair((Object)"vespa.match.feature", (Object)referenceNode.toString()));
            }
            for (ReferenceNode referenceNode : this.hiddenMatchFeatures) {
                properties.add(new Pair((Object)"vespa.hidden.matchfeature", (Object)referenceNode.toString()));
            }
            for (ReferenceNode referenceNode : this.rankFeatures) {
                properties.add(new Pair((Object)"vespa.dump.feature", (Object)referenceNode.toString()));
            }
            for (Map.Entry entry : this.featureRenames.entrySet()) {
                properties.add(new Pair((Object)"vespa.feature.rename", (Object)((String)entry.getKey())));
                properties.add(new Pair((Object)"vespa.feature.rename", (Object)((String)entry.getValue())));
            }
            if (this.numThreadsPerSearch > 0) {
                properties.add(new Pair((Object)"vespa.matching.numthreadspersearch", (Object)("" + this.numThreadsPerSearch)));
            }
            if (this.minHitsPerThread > 0) {
                properties.add(new Pair((Object)"vespa.matching.minhitsperthread", (Object)("" + this.minHitsPerThread)));
            }
            if (this.numSearchPartitions >= 0) {
                properties.add(new Pair((Object)"vespa.matching.numsearchpartitions", (Object)("" + this.numSearchPartitions)));
            }
            if (this.termwiseLimit < 1.0) {
                properties.add(new Pair((Object)"vespa.matching.termwise_limit", (Object)("" + this.termwiseLimit)));
            }
            if (this.sortBlueprintsByCost) {
                properties.add(new Pair((Object)"vespa.matching.sort_blueprints_by_cost", (Object)String.valueOf(this.sortBlueprintsByCost)));
            }
            if (this.alwaysMarkPhraseExpensive) {
                properties.add(new Pair((Object)"vespa.matching.always_mark_phrase_expensive", (Object)String.valueOf(this.alwaysMarkPhraseExpensive)));
            }
            if (this.postFilterThreshold.isPresent()) {
                properties.add(new Pair((Object)"vespa.matching.global_filter.upper_limit", (Object)String.valueOf(this.postFilterThreshold.getAsDouble())));
            }
            if (this.approximateThreshold.isPresent()) {
                properties.add(new Pair((Object)"vespa.matching.global_filter.lower_limit", (Object)String.valueOf(this.approximateThreshold.getAsDouble())));
            }
            if (this.targetHitsMaxAdjustmentFactor.isPresent()) {
                properties.add(new Pair((Object)"vespa.matching.nns.target_hits_max_adjustment_factor", (Object)String.valueOf(this.targetHitsMaxAdjustmentFactor.getAsDouble())));
            }
            if (this.matchPhaseSettings != null) {
                properties.add(new Pair((Object)"vespa.matchphase.degradation.attribute", (Object)this.matchPhaseSettings.getAttribute()));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.ascendingorder", (Object)("" + this.matchPhaseSettings.getAscending())));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.maxhits", (Object)("" + this.matchPhaseSettings.getMaxHits())));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.maxfiltercoverage", (Object)("" + this.matchPhaseSettings.getMaxFilterCoverage())));
                properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.degradation.samplepercentage", (Object)("" + this.matchPhaseSettings.getEvaluationPoint())));
                properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.degradation.postfiltermultiplier", (Object)("" + this.matchPhaseSettings.getPrePostFilterTippingPoint())));
                RankProfile.DiversitySettings diversitySettings = this.matchPhaseSettings.getDiversity();
                if (diversitySettings != null) {
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.attribute", (Object)diversitySettings.getAttribute()));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.mingroups", (Object)String.valueOf(diversitySettings.getMinGroups())));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.cutoff.factor", (Object)String.valueOf(diversitySettings.getCutoffFactor())));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.cutoff.strategy", (Object)String.valueOf(diversitySettings.getCutoffStrategy())));
                }
            }
            if (this.rerankCount > -1) {
                properties.add(new Pair((Object)"vespa.hitcollector.heapsize", (Object)("" + this.rerankCount)));
            }
            if (this.keepRankCount > -1) {
                properties.add(new Pair((Object)"vespa.hitcollector.arraysize", (Object)("" + this.keepRankCount)));
            }
            if (this.globalPhaseRerankCount > -1) {
                properties.add(new Pair((Object)"vespa.globalphase.rerankcount", (Object)("" + this.globalPhaseRerankCount)));
            }
            if (this.rankScoreDropLimit > -1.7976931348623157E308) {
                properties.add(new Pair((Object)"vespa.hitcollector.rankscoredroplimit", (Object)("" + this.rankScoreDropLimit)));
            }
            if (this.ignoreDefaultRankFeatures) {
                properties.add(new Pair((Object)"vespa.dump.ignoredefaultfeatures", (Object)String.valueOf(true)));
            }
            for (String string : this.filterFields) {
                properties.add(new Pair((Object)("vespa.isfilterfield." + string), (Object)String.valueOf(true)));
            }
            for (Map.Entry entry : this.attributeTypes.entrySet()) {
                properties.add(new Pair((Object)("vespa.type.attribute." + (String)entry.getKey()), (Object)((String)entry.getValue())));
            }
            for (RankProfile.Input input : this.inputs.values()) {
                if (!FeatureNames.isQueryFeature(input.name())) continue;
                if (input.type().tensorType().rank() > 0) {
                    properties.add((Pair<String, String>)new Pair((Object)("vespa.type.query." + input.name().arguments().expressions().get(0)), (Object)input.type().toString()));
                }
                if (!input.defaultValue().isPresent()) continue;
                properties.add((Pair<String, String>)new Pair((Object)input.name().toString(), (Object)(input.type().tensorType().rank() == 0 ? String.valueOf(input.defaultValue().get().asDouble()) : input.defaultValue().get().toString(true, false))));
            }
            if (properties.size() >= 1000000) {
                throw new IllegalArgumentException("Too many rank properties");
            }
            this.distributeLargeExpressionsAsFiles(properties, largeRankingExpressions);
            return properties;
        }

        private void distributeLargeExpressionsAsFiles(List<Pair<String, String>> properties, LargeRankingExpressions largeRankingExpressions) {
            ListIterator<Pair<String, String>> iter = properties.listIterator();
            while (iter.hasNext()) {
                String propertyName;
                String functionName;
                Pair<String, String> property = iter.next();
                String expression = (String)property.getSecond();
                if (expression.length() <= largeRankingExpressions.limit() || (functionName = RankingExpression.extractScriptName((String)(propertyName = (String)property.getFirst()))) == null) continue;
                String mangledName = this.rankprofileName + "." + functionName;
                largeRankingExpressions.add(new RankingExpressionBody(mangledName, ByteBuffer.wrap(expression.getBytes(StandardCharsets.UTF_8))));
                iter.set((Pair<String, String>)new Pair((Object)RankingExpression.propertyExpressionName((String)functionName), (Object)mangledName));
            }
        }

        private List<Pair<String, String>> deriveRankingPhaseRankProperties(RankingExpression expression, String phase) {
            ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
            if (expression == null) {
                return properties;
            }
            String name = expression.getName();
            if ("".equals(name)) {
                name = phase;
            }
            String expressionAsString = expression.getRoot().toString(this.functionSerializationContext).toString();
            if (expression.getRoot() instanceof ReferenceNode) {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.rank." + phase), (Object)expressionAsString));
            } else {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.rank." + phase), (Object)Reference.wrapInRankingExpression((String)name)));
                properties.add((Pair<String, String>)new Pair((Object)RankingExpression.propertyName((String)name), (Object)expressionAsString));
            }
            return properties;
        }

        private void deriveOnnxModelFunctionsAndFeatures(RankProfile rankProfile) {
            if (rankProfile.schema() == null) {
                return;
            }
            if (rankProfile.onnxModels().isEmpty()) {
                return;
            }
            this.replaceOnnxFunctionInputs(rankProfile);
            this.replaceImplicitOnnxConfigFeatures(this.summaryFeatures, rankProfile);
            this.replaceImplicitOnnxConfigFeatures(this.matchFeatures, rankProfile);
        }

        private void replaceOnnxFunctionInputs(RankProfile rankProfile) {
            Set<String> functionNames = rankProfile.getFunctions().keySet();
            if (functionNames.isEmpty()) {
                return;
            }
            for (OnnxModel onnxModel : rankProfile.onnxModels().values()) {
                for (Map.Entry<String, String> mapping : onnxModel.getInputMap().entrySet()) {
                    String source = mapping.getValue();
                    if (!functionNames.contains(source)) continue;
                    onnxModel.addInputNameMapping(mapping.getKey(), Reference.wrapInRankingExpression((String)source));
                }
            }
        }

        private void replaceImplicitOnnxConfigFeatures(Set<ReferenceNode> features, RankProfile rankProfile) {
            if (features == null || features.isEmpty()) {
                return;
            }
            HashSet<ReferenceNode> replacedFeatures = new HashSet<ReferenceNode>();
            Iterator<ReferenceNode> i = features.iterator();
            while (i.hasNext()) {
                ReferenceNode replacedNode;
                ReferenceNode referenceNode = i.next();
                if (referenceNode == (replacedNode = (ReferenceNode)OnnxModelTransformer.transformFeature(referenceNode, rankProfile))) continue;
                replacedFeatures.add(replacedNode);
                i.remove();
            }
            features.addAll(replacedFeatures);
        }
    }
}

